# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime, timedelta

from django.core.management import BaseCommand

from travel.rasp.train_api.train_purchase.core.enums import TrainPartner
from travel.rasp.train_api.train_purchase.core.models import ClientContracts, ClientContract


class Command(BaseCommand):
    help = 'Создаем активные контракты если нужно'

    def handle(self, *args, **kwargs):
        fresh_contract = ClientContract(
            start_dt=datetime.now() - timedelta(1),
            finish_dt=datetime.now() + timedelta(2000),
            is_active=True,
            partner_commission_sum=1.15,
            partner_commission_sum2=0.5,
        )
        for partner in (TrainPartner.IM, TrainPartner.UFS):
            if ClientContracts.get_active_contract(partner):
                self.stdout.write('Котракт для {} свежий'.format(partner))
                continue

            last_contract = ClientContracts.objects.filter(partner=partner).order_by('-updated_at').first()
            if not last_contract:
                last_contract = ClientContracts(
                    updated_at=datetime.now(), partner=partner, contracts=[fresh_contract]
                )
            else:
                last_contract.updated_at = datetime.now()
                last_contract.contracts.append(fresh_contract)
            last_contract.save()
            self.stdout.write('Обновили котракт для {}'.format(partner))
