# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.http import HttpResponse

from common.settings.utils import define_setting, bool_converter

define_setting('CHECK_ACTIVE_PARTNERS_IN_PING', default=False, converter=bool_converter)
define_setting('CHECK_DB_IN_PING', default=True, converter=bool_converter)


class PingResponder(object):
    def process_request(self, request):
        if request.path in ['/ping', '/ping/']:
            if settings.CHECK_DB_IN_PING:  # проверяем живость базы
                from django.db import connection
                connection.cursor().execute("select * from flags;")

            if settings.CHECK_ACTIVE_PARTNERS_IN_PING:
                from travel.rasp.train_api.train_purchase.core.enums import TrainPartner
                _partner_codes = [partner.value for partner in TrainPartner if partner.is_active]

            return HttpResponse("pong!", content_type='text/plain')
