# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

import locale
import logging

from django.utils.translation import get_language

log = logging.getLogger(__name__)


class SetLocale(object):
    def process_request(self, request):
        language = get_language()
        if language in ('uk', 'ru'):
            self.set_collate_locale('ru_RU.UTF8')  # Правильно сортируем украинские строки

        elif language == 'tr':
            self.set_collate_locale('tr_TR.UTF8')  # Правильно сортируем турецкие строки

    def set_collate_locale(self, locale_key):
        try:
            locale.setlocale(locale.LC_COLLATE, locale_key)
        except locale.Error:
            locale.setlocale(locale.LC_COLLATE, 'C')
            log.error(u'Не удалось установить локаль %s' % locale_key)
