import os

from travel.library.python.dicts.trains.coach_binding_repository import CoachBindingRepository
from travel.library.python.dicts.trains.coach_schema_repository import CoachSchemaRepository
from travel.library.python.dicts.trains.facility_repository import FacilityRepository
from travel.library.python.dicts.trains.service_class_repository import ServiceClassRepository
from travel.library.python.dicts.trains.station_express_alias_repository import StationExpressAliasRepository


class ProtobufDataProvider(object):
    def __init__(self):
        self.alias_repo = StationExpressAliasRepository(index_field='Alias')
        self.coach_schema_repo = CoachSchemaRepository()
        self.coach_binding_repo = CoachBindingRepository()
        self.facility_repo = FacilityRepository(index_field='Code')
        self.service_class_repo = ServiceClassRepository()

    def load_from_dir(self, proto_dir):
        repo_filenames = [
            (self.alias_repo, 'station_express_alias.bin'),
            (self.coach_binding_repo, 'coach_binding.bin'),
            (self.coach_schema_repo, 'coach_schema.bin'),
            (self.facility_repo, 'facility.bin'),
            (self.service_class_repo, 'service_class.bin'),
        ]

        for repo, filename in repo_filenames:
            repo.load_from_file(os.path.join(proto_dir, filename))
