# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from marshmallow import Schema, fields, missing

from common.serialization.common_schemas import PriceSchema
from travel.rasp.train_api.serialization.fields import CallableStringField


class BaseSettlementSchema(Schema):
    id = fields.Integer()
    point_key = fields.String(dump_to='key')
    slug = fields.String()
    title = CallableStringField(attribute='L_title', dump_to='title')


class DepartureSettlementSchema(BaseSettlementSchema):
    direction_title = CallableStringField(attribute='L_title_phrase_from', dump_to='directionTitle')


class BestOfferSchema(Schema):
    departure_date = fields.Date(dump_to='departureDate')
    number = fields.String()
    price = fields.Nested(PriceSchema)


class ArrivalSettlementSchema(BaseSettlementSchema):
    direction_title = CallableStringField(attribute='L_title_phrase_to', dump_to='directionTitle')
    best_offer = fields.Method('_dump_best_offer', dump_to='bestOffer')
    image_url = fields.Method('_dump_image_url', dump_to='imageUrl')

    def _dump_best_offer(self, settlement):
        best_offer = self.context.get('best_offers', {}).get(settlement)
        return BestOfferSchema(strict=True).dump(best_offer).data if best_offer else missing

    def _dump_image_url(self, settlement):
        return self.context.get('image_urls', {}).get(settlement, missing)


class PopularDirectionsSchema(Schema):
    departure_city = fields.Nested(DepartureSettlementSchema, dump_to='departureCity')
    arrival_cities = fields.Nested(ArrivalSettlementSchema, dump_to='arrivalCities', many=True)
