# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import json
import os.path

from library.python import resource

SETTLEMENT_IMAGE_URLS = None
DEFAULT_SETTLEMENT_IMAGE_URLS = None


def _prepare_image_urls():
    global SETTLEMENT_IMAGE_URLS, DEFAULT_SETTLEMENT_IMAGE_URLS

    if SETTLEMENT_IMAGE_URLS is None:
        SETTLEMENT_IMAGE_URLS = {
            int(settlement_id): image_url
            for settlement_id, image_url in json.loads(_get_json_data('settlement_images.json')).items()
        }
        DEFAULT_SETTLEMENT_IMAGE_URLS = json.loads(_get_json_data('settlement_image_defaults.json'))


def get_settlement_image_urls(settlements):
    _prepare_image_urls()
    return {
        settlement:
            SETTLEMENT_IMAGE_URLS.get(settlement.id) or
            DEFAULT_SETTLEMENT_IMAGE_URLS[settlement.id % len(DEFAULT_SETTLEMENT_IMAGE_URLS)]
        for settlement in settlements
    }


def _get_json_data(filename):
    json_path = os.path.dirname(__file__)
    return resource.find(os.path.join('resfs/file', json_path, filename))
