# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import re

from bson.objectid import ObjectId

from common.db.mongo.bulk_buffer import BulkBuffer
from travel.rasp.train_api.train_purchase.backoffice.order_logs import database


log = logging.getLogger(__name__)


def clean_mongo_logs(from_id=None, to_id=None):
    log.info('Зачищаем персональные данные из логов')
    p = re.compile('\"(DocumentNumber|BirthDate|Birthday)\":\s\"([^"]+)\"')
    query = {'name': 'train_api.train_partners.im.base'}
    if from_id:
        query['_id'] = {'$gt': ObjectId(from_id)}
    if to_id:
        query['_id'] = (query.get('_id') or {}).update({'$lt': ObjectId(to_id)})
    last_updated_id = 0
    try:
        with BulkBuffer(database.order_logs, logger=log) as buffer:
            for log_record in database.order_logs.find(query):
                message = log_record['message']
                message = p.sub(r'"\1": "***.."', message)
                buffer.update_one({'_id': log_record['_id']}, {'$set': {'message': message}})
                last_updated_id = log_record['_id']
        log.info('Зачистка завершена')
    except Exception:
        log.info('Последняя обработанная запись {0}'.format(last_updated_id))
        raise
