# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import timedelta, datetime

from travel.rasp.train_api.train_purchase.views.cpa.views import build_orders_queryset
from travel.rasp.train_api.train_purchase.views.cpa.serialization import CpaOrderResponseSchema

log = logging.getLogger(__name__)


def get_cpa_orders(date=datetime(2020, 3, 6)):
    data = {'utc_from': date, 'utc_to': date + timedelta(days=1)}
    orders_queryset = build_orders_queryset(data)
    return [
        flatten_order(order)
        for order in orders_queryset
    ]


def flatten_order(order):
    try:
        return CpaOrderResponseSchema.flatten_order(order)
    except Exception as ex:
        log.error('Error flatten_order uid=%s. %s', order.uid, ex)


def replace_extractor(extractor):
    extractor_index = next((i for i, e in enumerate(CpaOrderResponseSchema.EXTRACTORS) if e.name == extractor.name),
                           None)
    if extractor_index is not None:
        CpaOrderResponseSchema.EXTRACTORS[extractor_index] = extractor
