# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from collections import Counter

from travel.rasp.train_api.train_purchase.core.models import TrainOrder

log = logging.getLogger(__name__)


MAPPING = {
    'АЗ': 'АЗ',
    'АО "ТКС"': 'ТКС',
    'АО ПК САХАЛИН': 'ПКС',
    'АО СЕВ-ЗАП ППК': 'СЗППК',
    'АО ТК "ГСЭ"': 'ГРАНД',
    'БЧ': 'БЧ',
    'ДОСС РЖД': 'ДОСС',
    'ЗАО ТК "ГСЭ"': 'ГРАНД',
    'КЗХ АО ПРИГ.ПЕР-КИ': 'КТЖПРГ',
    'КЗХ АРАЙ ТРАНС КZ': 'АРАЙ',
    'КЗХ АРЛАН-ТРАНС-АСТ': 'АРЛАН',
    'КЗХ КТЖ': 'КТЖ',
    'КЗХ МАРАЛ-НУР': 'МАРНУР',
    'КЗХ НОМАДАС': 'НОМАД',
    'КЗХ САРЫ-АРКА КОМП': 'САРЫАР',
    'КЗХ ТУРАН ЭКСПРЕСС': 'ТУРАН',
    'КЗХ ТУРКСИБ-АСТАНА': 'ТУРСИБ',
    'КРГ': 'КРГ',
    'ЛГ': 'ЛГ',
    'ЛДЗ': 'ЛДЗ',
    'ОАО ЦЕНТР ППК': 'ЦППК',
    'ТВЕРСКОЙ ЭКСПР': 'ТВЕРСК',
    'ТДЖ': 'ТДЖ',
    'УЗ ЛЬВ': 'УЗ',
    'УЗ ОД': 'УЗ',
    'УЗ ПРИДН': 'УЗ',
    'УЗ Ю-З': 'УЗ',
    'УЗ ЮЖН': 'УЗ',
    'УТИ': 'УТИ',
    'ФПК ВОСТ-СИБИРСКИЙ': 'ФПК',
    'ФПК ГОРЬКОВСКИЙ': 'ФПК',
    'ФПК ДАЛЬНЕВОСТОЧНЫЙ': 'ФПК',
    'ФПК ЕНИСЕЙСКИЙ': 'ФПК',
    'ФПК ЗАБАЙКАЛЬСКИЙ': 'ФПК',
    'ФПК ЗАП-СИБИРСКИЙ': 'ФПК',
    'ФПК КУЙБЫШЕВСКИЙ': 'ФПК',
    'ФПК МОСКОВСКИЙ': 'ФПК',
    'ФПК ПРИВОЛЖСКИЙ': 'ФПК',
    'ФПК СЕВ-ЗАПАДНЫЙ': 'ФПК',
    'ФПК СЕВ-КАВКАЗСКИЙ': 'ФПК',
    'ФПК СЕВЕРНЫЙ': 'ФПК',
    'ФПК УРАЛЬСКИЙ': 'ФПК',
    'ФПК ЮГО-ВОСТОЧНЫЙ': 'ФПК',
    'ФПК ЮЖНО-УРАЛЬСКИЙ': 'ФПК',
    'ФРАХТ АО "ФПК"': 'ФПК',
    'ЦЕНТРАЛЬНАЯ ППК': 'ЦППК',
    'ЧФМ': 'ЧФМ',
}
for v in set(MAPPING.values()):
    MAPPING[v] = v


def fill_chunk():
    modified = False
    chunk = TrainOrder.objects.filter(displayed_coach_owner=None).values_list('uid', 'coach_owner')[:500]
    for uid, coach_owner in chunk:
        displayed_coach_owner = MAPPING.get(coach_owner)
        if not displayed_coach_owner:
            log.error('Can not get displayed_coach_owner for uid %s and coach_owner %s', uid, coach_owner)
            continue
        TrainOrder.objects.filter(uid=uid).update(set__displayed_coach_owner=displayed_coach_owner)
        modified = True
    return modified


def calc_stat():
    return Counter(TrainOrder.objects.filter(displayed_coach_owner=None).values_list('coach_owner'))


if __name__ == '__main__':
    while fill_chunk():
        pass

    print(calc_stat())
