# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.data_api.billing.trust_client import TrustClient, TrustPaymentStatuses
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.train_api.train_purchase.core.models import TrainOrder, RefundPaymentStatus
from travel.rasp.train_api.train_purchase.workflow.payment import PaymentState
from travel.rasp.train_api.train_purchase.workflow.payment.create_refund_payment import calculate_refund_payment_orders


def force_clear_payment(order_uid, set_reversal_id=False):
    trust_client = TrustClient()
    order = TrainOrder.objects.get(uid=order_uid)
    payment = order.current_billing_payment

    trust_client.clear_payment(payment.purchase_token)

    payment.update(**{
        'set__clear_at': now_utc(),
        'set__process__state': PaymentState.CLEARED,
        'set__status': TrustPaymentStatuses.CLEARED.value,
    })

    if set_reversal_id:
        force_set_reversal_id(payment.current_refund_payment)


def force_resize_payment(order_uid, refund_payment_id):
    order = TrainOrder.objects.get(uid=order_uid)
    payment = order.current_billing_payment
    payment.current_refund_payment_id = refund_payment_id
    refund_payment = payment.current_refund_payment
    refund_orders = calculate_refund_payment_orders(order, refund_payment)
    trust_client = TrustClient(user_ip=refund_payment.user_info.ip,
                               user_region_id=refund_payment.user_info.region_id)

    for refund_order in refund_orders:
        trust_client.resize_payment_order(refund_payment.purchase_token, refund_order.order_id,
                                          refund_order.result_amount)

    force_clear_payment(order.uid)

    force_set_reversal_id(refund_payment)

    payment.save()


def force_set_reversal_id(refund_payment):
    trust_client = TrustClient()

    pay_info = trust_client.get_payment_info(refund_payment.purchase_token)

    refund_payment.update(**{
        'set__payment_resized': True,
        'set__refund_payment_finished_at': now_utc(),
        'set__refund_payment_status': RefundPaymentStatus.DONE,
        'set__trust_reversal_id': pay_info.reversal_id,
    })
