# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.train_api.train_partners.im.base import get_im_response
from travel.rasp.train_api.train_partners.im.insurance.checkout import _checkout_passenger
from travel.rasp.train_api.train_partners.im.insurance.pricing import pricing
from travel.rasp.train_api.train_purchase.core.enums import OperationStatus
from travel.rasp.train_api.train_purchase.core.models import TrainOrder

log = logging.getLogger(__name__)


def re_checkout_insurance(order_uid, operation_ids):
    """
    :param str order_uid: UID заказа
    :param list(str) operation_ids: Массив OrderITemId страховок на перезаказ
    :return:
    """
    def _cancel_insurance(operation_id):
        try:
            data = {'OrderItemId': operation_id}
            get_im_response('Insurance/V1/Travel/Cancel', data)
        except Exception:
            log.exception('Error in _cancel_insurance(%s)', operation_id)

    def _pricing_insurance(insurance, result):
        insurance.amount = result.amount
        insurance.package = result.package
        insurance.provider = result.provider
        insurance.company = result.company
        insurance.compensation = result.compensation

    def _purchase_insurance(operation_id):
        data = {'OrderItemId': operation_id}
        get_im_response('Insurance/V1/Travel/Purchase', data)

    try:
        order = TrainOrder.objects.get(uid=order_uid)
        pricing_results = pricing(order)
        pricing_results_by_customer_id = {result.customer_id: result for result in pricing_results}

        for passenger in order.passengers:
            if not passenger.insurance or not passenger.insurance.operation_id \
                    or passenger.insurance.operation_id not in operation_ids:
                continue
            insurance = passenger.insurance

            _cancel_insurance(insurance.operation_id)
            _pricing_insurance(insurance, pricing_results_by_customer_id[passenger.customer_id])
            new_operation_id = _checkout_passenger(order, passenger)
            _purchase_insurance(new_operation_id)

            insurance.operation_id = new_operation_id
            insurance.operation_status = OperationStatus.OK

            order.save()

    except Exception:
        log.exception('Error in re_checkout_insurance')
