# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
from random import random
from subprocess import check_call
from time import sleep

SECONDS_BETWEEN_RESTARTS = 60 * 60
MAX_RANDOM_SLEEP_SECONDS = max(0, SECONDS_BETWEEN_RESTARTS - 5 * 60)
NUMBER_OF_INSTANCES = int(os.getenv('RESTART_BY_CRON_NUMBER_OF_INSTANCES', 15))
SECONDS_BETWEEN_INSTANCES = SECONDS_BETWEEN_RESTARTS / NUMBER_OF_INSTANCES


def wait_my_turn():
    """
    Нужно разнести рестарты по времени
    """
    try:
        instance_number = int(os.getenv('QLOUD_DISCOVERY_INSTANCE').split('.')[0].rsplit('-', 1)[1])
    except (AttributeError, IndexError, ValueError):
        # если не получилось разобрать, то просто спим рандомно
        sleep(random.uniform(0, MAX_RANDOM_SLEEP_SECONDS))
    else:
        sleep((instance_number - 1) * SECONDS_BETWEEN_INSTANCES)


def main():
    if os.getenv('RESTART_BY_CRON_IS_ON'):
        wait_my_turn()
        check_call('/usr/local/bin/supervisorctl restart application'.split())
