# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import datetime

from bson import ObjectId

from travel.rasp.train_api.train_purchase.core.enums import TravelOrderStatus, OrderStatus
from travel.rasp.train_api.train_purchase.core.models import TrainOrder

log = logging.getLogger(__name__)


class TravelStatusMigration(object):
    objects_in_step = 500

    @staticmethod
    def migrate_one(order):
        try:
            travel_status = order.get_actual_travel_status()
            order.update(set__travel_status=travel_status)
            return travel_status
        except Exception:
            log.exception('Failed. order={}'.format(order.uid))
            return None

    @staticmethod
    def find_orders_to_migrate():
        return TrainOrder.objects.filter(travel_status__exists=False).order_by('_id')

    def migrate_all(self):
        log.info('Start migrate travel_status')
        while True:
            migrated_count = 0
            for order in self.find_orders_to_migrate()[:self.objects_in_step]:
                if self.migrate_one(order):
                    migrated_count += 1
            log.info('Step. migrated={0}'.format(migrated_count))
            if migrated_count == 0:
                break
        log.info('Done migrate travel_status')

    @staticmethod
    def find_exception_orders_to_migrate(min_id):
        return TrainOrder.objects.filter(id__gt=min_id, status=OrderStatus.DONE,
                                         travel_status=TravelOrderStatus.CANCELLED).order_by('_id')

    def migrate_all_exception_orders(self):
        log.info('Start migrate exception_orders travel_status')
        min_id = ObjectId.from_datetime(datetime(2017, 1, 1))
        while True:
            migrated_count = 0
            for order in self.find_exception_orders_to_migrate(min_id)[:10]:
                travel_status = self.migrate_one(order)
                min_id = order.id
                if travel_status:
                    migrated_count += 1
                    log.info('Migrated. order={}, travel_status={}'.format(order.uid, travel_status))
            log.info('Step. migrated={0}'.format(migrated_count))
            if migrated_count == 0:
                break
        log.info('Done migrate exception_orders travel_status')


def run():
    migration = TravelStatusMigration()
    migration.migrate_all()
