# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

"""
    Model from avia/travelers repo
    https://github.yandex-team.ru/avia/travelers/blob/release/application/models.py
"""

from abc import ABCMeta, abstractmethod
from datetime import datetime

import six


@six.add_metaclass(ABCMeta)
class AbstractModel(object):
    @abstractmethod
    def __init__(self):
        pass

    def fill(self, data):
        self.__dict__.update(data)

        return self

    def __repr__(self):
        return '{}: {}'.format(type(self), self.__dict__)


class Traveler(AbstractModel):
    def __init__(self):
        super(Traveler, self).__init__()
        self.id = None
        self.agree = False
        self.phone = None
        self.phone_additional = None
        self.email = None
        self.created_at = None
        self.updated_at = None


class Passenger(AbstractModel):
    def __init__(self):
        super(Passenger, self).__init__()
        self.id = None
        self.traveler_id = None
        self.title = None
        self.gender = None
        self.birth_date = None
        self.phone = None
        self.phone_additional = None
        self.email = None
        self.created_at = None
        self.updated_at = None

    def fill(self, data):
        super(Passenger, self).fill(data)

        if isinstance(self.birth_date, datetime):
            self.birth_date = self.birth_date.date()

        return self


class Document(AbstractModel):
    def __init__(self):
        super(Document, self).__init__()
        self.id = None
        self.passenger_id = None
        self.type = None
        self.title = None
        self.number = None
        self.first_name = None
        self.middle_name = None
        self.last_name = None
        self.first_name_en = None
        self.middle_name_en = None
        self.last_name_en = None
        self.issue_date = None
        self.expiration_date = None
        self.citizenship = None
        self.created_at = None
        self.updated_at = None

    def fill(self, data):
        super(Document, self).fill(data)

        if isinstance(self.issue_date, datetime):
            self.issue_date = self.issue_date.date()
        if isinstance(self.expiration_date, datetime):
            self.expiration_date = self.expiration_date.date()

        return self


class BonusCard(AbstractModel):
    def __init__(self):
        super(BonusCard, self).__init__()
        self.id = None
        self.passenger_id = None
        self.type = None
        self.title = None
        self.number = None
        self.created_at = None
        self.updated_at = None
