from __future__ import unicode_literals, absolute_import, division, print_function

import os

import ydb

from travel.rasp.train_api.helpers.ydb import ydb_provider
from travel.rasp.train_api.train_purchase.utils.logs import YDB_ORDER_LOGS_TABLE_NAME


def create_order_logs_table(session, table_name):
    session.create_table(
        table_name,
        ydb.TableDescription()
        .with_column(ydb.Column('order_uid', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('created_utc', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('name', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('levelname', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('message', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('created', ydb.OptionalType(ydb.PrimitiveType.Utf8)))
        .with_column(ydb.Column('process', ydb.OptionalType(ydb.PrimitiveType.Int32)))
        .with_column(ydb.Column('context', ydb.OptionalType(ydb.PrimitiveType.Json)))
        .with_column(ydb.Column('exception', ydb.OptionalType(ydb.PrimitiveType.Json)))
        .with_primary_keys('order_uid', 'created_utc')
    )


def is_table_exists(driver, path):
    try:
        return driver.scheme_client.describe_path(path).is_table()
    except ydb.SchemeError:
        return False


def run():
    full_table_path = os.path.join(ydb_provider.connection_params.database, YDB_ORDER_LOGS_TABLE_NAME)
    if not is_table_exists(ydb_provider.get_driver(), full_table_path):
        session = ydb_provider.get_session()
        create_order_logs_table(session, full_table_path)
