# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import json
import logging
from marshmallow import Schema, fields

log = logging.getLogger(__name__)

UAAS_EXP_HEADER = 'HTTP_X_YA_UAAS_EXPERIMENTS'


class ExperimentQuerySchema(Schema):
    bandit_type = fields.String(missing=None)
    icookie = fields.String(missing=None)
    req_id = fields.String(missing=None)
    test_buckets = fields.String(missing=None)
    user_device = fields.String(missing=None)
    yandex_uid = fields.String(missing=None)
    train_api_use_worker = fields.String(missing=None)

    @classmethod
    def prepare_query_from_headers(cls, headers, query):
        headers_to_query = {
            'HTTP_X_YA_ICOOKIE': 'icookie',
            'HTTP_X_REQUEST_ID': 'req_id',
            'HTTP_X_YA_EXPBOXES': 'test_buckets',
            'HTTP_X_YA_USER_DEVICE': 'user_device',
            'HTTP_X_YA_YANDEXUID': 'yandex_uid',
        }

        prepared_query = query.copy()

        for header, key in headers_to_query.items():
            if not prepared_query.get(key):
                prepared_query[key] = headers.get(header)

        try:
            uaas_experiments = headers.get(UAAS_EXP_HEADER)
            if uaas_experiments:
                uaas_map = json.loads(uaas_experiments)
                prepared_query['bandit_type'] = uaas_map.get('TRAINS_bandit_type')
                prepared_query['train_api_use_worker'] = uaas_map.get('TRAIN_API_USE_WORKER')
        except Exception:
            log.error("error parse uaas_experiments")

        return prepared_query
