# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields, missing

from travel.rasp.train_api.data_layer.point import get_point_timezone
from travel.rasp.train_api.serialization.fields import CallableStringField


class CountrySchema(Schema):
    id = fields.Integer()
    code = fields.String()


class SegmentStationSchema(Schema):
    id = fields.Integer()
    title = CallableStringField(attribute='L_title', dump_to='title')
    popular_title = CallableStringField(attribute='L_popular_title', dump_to='popularTitle')
    settlement_id = fields.Integer(dump_to='settlementId')
    timezone = fields.Function(lambda s: get_point_timezone(s))
    country = fields.Method('_dump_country')
    codes = fields.Method('fill_codes')

    def _dump_country(self, station):
        if self.context.get('dump_country_for_station', False) and station.country_id is not None:
            return CountrySchema().dump(station.country).data

    def fill_codes(self, station):
        codes = {}
        if self.context.get('express_by_station_id_cache'):
            express_code = self.context['express_by_station_id_cache'].get(station.id)
            if express_code:
                codes['express'] = express_code
        return codes or missing
