# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields, missing

from travel.rasp.train_api.serialization.fields import CallableStringField


class TransportModelSchema(Schema):
    title = CallableStringField(attribute='L_title', dump_to='title')


class TransportSubTypeSchema(Schema):
    id = fields.Integer()
    code = fields.String()
    title = CallableStringField(attribute='L_title', dump_to='title')
    title_color = fields.Method('get_title_color', dump_to='titleColor')

    def get_title_color(self, obj):
        color = obj.color
        return missing if color is None else color.color


class DeluxeTrainSchema(Schema):
    id = fields.Integer()
    title = CallableStringField(attribute='L_title', dump_to='title')
    short_title = CallableStringField(attribute='L_title_short', dump_to='shortTitle')
    is_deluxe = fields.Boolean(attribute='deluxe', dump_to='isDeluxe', default=False)
    is_high_speed = fields.Boolean(attribute='high_speed', dump_to='isHighSpeed', default=False)
    page_path = fields.String(dump_to='pagePath')


def build_transport(segment):
    t_type = segment.t_type
    t_subtype = segment.thread and segment.thread.t_subtype
    rtstation_from = getattr(segment, 'rtstation_from', None)
    t_model = rtstation_from and rtstation_from.departure_t_model or getattr(segment, 't_model', None)

    transport_data = {
        'id': t_type.id,
        'code': t_type.code,
        'title': t_type.L_title(),
    }
    if t_model:
        transport_data['model'] = TransportModelSchema().dump(t_model).data
    if t_subtype:
        transport_data['subtype'] = TransportSubTypeSchema().dump(t_subtype).data
    return transport_data
