# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api import monkey_patch
monkey_patch.add_read_retry_to_pymongo()

from common.settings import *  # noqa

import getpass
import logging
import os

from library.python.django.utils import patch_settings_for_arcadia  # noqa
from common.settings.configuration import BaseConfigurator, Configuration
from travel.rasp.library.python.common23.settings.configuration import BaseRedisCacheConfigurator
from common.settings.utils import get_app_version, bool_converter
from travel.rasp.library.python.common23.logging.qloud import context_extractor
from rasp_vault.api import get_secret


ALLOWED_HOSTS = ['*']

PKG_VERSION = get_app_version()

CELERY_WORKER_HIJACK_ROOT_LOGGER = False
CELERY_WORKER_PREFETCH_MULTIPLIER = 1
CELERY_TASK_ACKS_LATE = True

SQS_ENDPOINT = 'sqs.yandex.net:8771'
SQS_SECRET_KEY = 'not-used-yet'

OPENTRACING_TRACE_ALL = True
OPENTRACING_TRACED_ATTRIBUTES = ['path', 'method']

INSTALLED_APPS = COMMON_CONTRIB_APPS + [  # noqa
    'django.contrib.staticfiles',
    'django_opentracing',
    'rest_framework',
    'rest_framework_swagger',
] + COMMON_INSTALLED_APPS + [  # noqa
    'route_search',
    'travel.rasp.train_api',
]


syncdb_middleware = [] if os.getenv('DISABLE_SYNCDB', False) else ['common.middleware.syncdb.SyncDB']
MIDDLEWARE_CLASSES = [
    'common.middleware.extract_context.ExtractRequestMiddleware',
    'travel.rasp.train_api.middleware.ping.PingResponder',
] + syncdb_middleware + [  # noqa
    'django.middleware.locale.LocaleMiddleware',
    'django_opentracing.OpenTracingMiddleware',
    'travel.library.python.tracing.django.TracingMiddleware',
    'travel.rasp.train_api.middleware.set_locale.SetLocale'
]

STATIC_ROOT = os.path.join(PROJECT_PATH, 'static')  # noqa

ROOT_URLCONF = 'travel.rasp.train_api.urls_async'


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = with_suffix('.objects.precache', [
    'common.models.geo:StationType',
    'common.models.tariffs:TariffType',
    'common.models.transport:TransportType',
    'common.models.transport:TransportSubtype',
    'common.models.schedule:PlatformTranslation',
    'common.models.geo:CodeSystem',
    'common.apps.train.models:CoachType',
    'common.apps.train.models:Facility',
    # Эти объекты используются в route_search
    'common.models.schedule:Company',
    'common.models.schedule:Supplier',
    'common.models.schedule:RThreadType',  # для Schedule.L_days_text_dict
    'common.models.geo:StationMajority',
    'common.models.geo:Country',  # нужно для получения timezone ч/з Express2Country
    'common.models.currency:Currency',
    'common.models.schedule:DeLuxeTrain',
]) + [
    'common.importinfo.models:Express2Country.precache',
    'common.models.geo:ReplaceException.precache',
    'common.models.geo:Station.code_manager.precache',
    'travel.rasp.train_api.tariffs.train.base.country_availability_manager:country_availability_manager.precache'
]

PROTO_DIR = os.getenv('TRAIN_API_PROTO_DIR', '/app/data/')
TRAIN_API_LOAD_PROTOBUFS = os.getenv('TRAIN_API_LOAD_PROTOBUFS', False)

REST_FRAMEWORK = {
    'EXCEPTION_HANDLER': 'travel.rasp.train_api.helpers.error.rest_framework_exception_handler'
}

# Время ожидания ответа партнера
DEFAULT_PARTNER_TIMEOUT = int(os.getenv('DEFAULT_PARTNER_TIMEOUT', 60 * 3))
# Время ожидания заполнения кеша данными от партнера
TARIFF_SUPPLIERWAIT_TIMEOUT = 60 * 5
UFS_TRAIN_DETAILS_ERROR_TIMEOUT = 60 * 15
PATHFINDER_EXPIRED_TIMEOUT_MINUTES = 60 * 5

UFS_RESPONSE_LOG = '/dev/null'
IM_CAR_PRISING_LOG = '/dev/null'
DINAMIC_TARIFFS_LOG = '/dev/null'

PYLOGCTX_REQUEST_EXTRACTOR = context_extractor

XGETTEXT_KEYSETS.update({  # noqa
    'morda_backend': {
        'filename': 'xgettext/keyset.json',
        'dirs': [
            'travel/rasp/train_api',
        ]
    }
})

YASMAGENT_ITYPE = 'raspback'
YASMAGENT_PROJECT = 'raspback'

MONGO_DATABASES.update({  # noqa
    'train_purchase': {
        'db': 'train_purchase',
        'options': {
            'socketTimeoutMS': 4000,
            'heartbeatFrequencyMS': 3000,
        },
    }
})

patch_settings_for_arcadia()


class RaspBackendConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        """
        Errors to be ignored if were decide to use Error-booster someday.
        'pymongo.errors.NetworkTimeout',
        'MySQLdb.OperationalError',
        'travel.rasp.train_api.train_partners.im.base.ImNonCriticalError',

        """
        settings['LOG_PATH'] = '/var/log/application'

        settings['CACHEROOT'] = '/yandex/rasp-morda-backend/'  # CACHEROOT переписывается в switch_db

        settings['MONGO_DATABASES'].setdefault('default', {}).setdefault('options', {}).update({
            'heartbeatFrequencyMS': 3000,
        })

        settings['EMAIL_SENDER_DB_ALIAS'] = 'train_purchase'
        settings['EMAIL_SENDER_CALLBACK_ON_MAX_ALLOWED_TIME_IN_QUEUE_EXCEEDED'] = \
            'travel.rasp.train_api.train_purchase.utils.email_sender_callback.report_fail_email'

        settings['LOCK_DATABASE_NAME'] = 'train_purchase'
        settings['TVM_SERVICE_ID'] = 'train-api'
        settings['TVM_DESTINATIONS'] = ['TVM_TRAVELERS', 'TVM_DATASYNC', 'TVM_BANDIT', 'TVM_BALANCE']
        settings['TVM_TIMEOUT'] = 0.05
        settings['YT_LOGS_SUB_DIR'] = 'yt-test'

        self.setup_logging(settings)

    def apply_production(self, settings):
        settings['TICKETS_QUERY_URL'] = 'http://daemon.avia.yandex.net/api/1.0/'

        settings['SQS_ACCESS_KEY'] = 'train'
        settings['CELERY_TASK_DEFAULT_QUEUE'] = 'celery.default'
        settings['YT_LOGS_SUB_DIR'] = 'yt'

        self._setup_yt_logs(settings)

    def apply_testing(self, settings):
        settings['YANDEX_INTERNAL_ROOT_CA'] = '/usr/local/share/ca-certificates/YandexInternalRootCA.crt'
        settings['SHORTENER_URL'] = 'http://api.ya.cc'  # с продовой сокращалкой урлов асессоры смогут перейти по ссылке

        settings['SQS_ACCESS_KEY'] = 'train-test'
        settings['CELERY_TASK_DEFAULT_QUEUE'] = 'celery.default'

    def apply_development(self, settings):
        settings['DEBUG'] = True
        settings['YANDEX_INTERNAL_ROOT_CA'] = False
        settings['STATIC_URL'] = '/static/'
        settings['CELERY_DEV_APP_MODULE'] = 'travel.rasp.train_api.celery.worker.app'

        settings['LOG_PATH'] = os.path.join(os.path.dirname(__file__), 'log')
        self.setup_logging(settings)
        self._setup_yt_logs(settings)

        self._setup_django_toolbar(settings)

        settings['SQS_ACCESS_KEY'] = 'train-dev'
        settings['CELERY_TASK_DEFAULT_QUEUE'] = '{}.celery.default'.format(getpass.getuser())

    def apply_stress(self, settings):
        settings['SQS_ACCESS_KEY'] = 'train-dev'
        settings['CELERY_TASK_DEFAULT_QUEUE'] = 'stress.celery.default'

    def apply_after_all(self, settings):
        self.setup_logging(settings)

        settings['CELERY_BROKER_TRANSPORT_OPTIONS'] = {
            'is_secure': False,
            'region': 'yandex'
        }
        self._setup_celery_broker_url(settings)

    @staticmethod
    def _setup_django_toolbar(settings):
        if 'debug_toolbar' not in settings['INSTALLED_APPS']:
            settings['INSTALLED_APPS'].extend([
                'debug_toolbar'
            ])
        settings['MIDDLEWARE_CLASSES'] = ['debug_toolbar.middleware.DebugToolbarMiddleware'] + settings['MIDDLEWARE_CLASSES']
        settings['DEBUG_TOOLBAR_PATCH_SETTINGS'] = False
        settings['DEBUG_TOOLBAR_CONFIG'] = {
            'SHOW_TOOLBAR_CALLBACK': lambda _: True
        }

        settings['DEBUG_TOOLBAR_PANELS'] = [
            'debug_toolbar.panels.versions.VersionsPanel',
            'debug_toolbar.panels.timer.TimerPanel',
            'debug_toolbar.panels.settings.SettingsPanel',
            'debug_toolbar.panels.headers.HeadersPanel',
            'debug_toolbar.panels.request.RequestPanel',
            'debug_toolbar.panels.sql.SQLPanel',
            'debug_toolbar.panels.staticfiles.StaticFilesPanel',
            'debug_toolbar.panels.templates.TemplatesPanel',
            'debug_toolbar.panels.cache.CachePanel',
            'debug_toolbar.panels.signals.SignalsPanel',
            'debug_toolbar.panels.logging.LoggingPanel',
            'debug_toolbar.panels.redirects.RedirectsPanel',
            'debug_toolbar.panels.profiling.ProfilingPanel',
        ]

    @staticmethod
    def _setup_yt_logs(settings):
        log_path = settings['LOG_PATH']
        yt_dir = settings['YT_LOGS_SUB_DIR']
        settings['DINAMIC_TARIFFS_LOG'] = os.path.join(log_path, yt_dir, 'dynamic_tariffs.log')
        settings['UFS_RESPONSE_LOG'] = os.path.join(log_path, yt_dir, 'ufs_carlistex.log')
        settings['IM_CAR_PRISING_LOG'] = os.path.join(log_path, yt_dir, 'im_carpricing.log')

    @staticmethod
    def _setup_celery_broker_url(settings):
        settings['CELERY_BROKER_URL'] = 'sqs://{access_key}:{secret_key}@{endpoint}'.format(
            access_key=settings['SQS_ACCESS_KEY'],
            secret_key=settings['SQS_SECRET_KEY'],
            endpoint=settings['SQS_ENDPOINT']
        )

    @staticmethod
    def setup_logging(settings, base_log_level=None):
        if not base_log_level:
            base_log_level = settings.get('BASE_LOG_LEVEL', 'INFO')

        _format = '%(levelname)s %(asctime)s %(process)d %(context)s %(name)s %(message)s'
        _format_with_context = '%(levelname)s %(asctime)s %(context)s %(process)d %(name)s %(message)s'

        log_path = settings['LOG_PATH']
        yt_dir = settings['YT_LOGS_SUB_DIR']
        settings['LOGGING'] = {
            'version': 1,
            'disable_existing_loggers': False,
            'formatters': {
                'simple': {
                    'format': _format
                },
                'context': {
                    'format': _format_with_context
                },
                'exception': {
                    '()': 'ylog.ExceptionFormatter',
                    'full': True,
                    'format': _format
                },
                'deploy_warnings': {
                    '()': 'travel.rasp.library.python.common23.logging.deploy.DeployJsonFormatter',
                    'tag': 'warnings'
                },
                'deploy_application': {
                    '()': 'travel.rasp.library.python.common23.logging.deploy.DeployJsonFormatter',
                    'tag': 'application'
                },
                'deploy_errors': {
                    '()': 'travel.rasp.library.python.common23.logging.deploy.DeployJsonFormatter',
                    'add_request_info': True,
                    'tag': 'errors'
                },
                'yt_order_log_json': {
                    '()': 'travel.rasp.library.python.common23.logging.JsonFormatter',
                    'keys_to_log': ['timestamp', 'order_uid', 'request_id', 'reserved_to', 'num_of_tickets', 'amount',
                                    'fee', 'fee_without_im', 'device', 'yandex_uid'],
                    'omit_mandatory': True,
                },
                'bandit_train_details_log_json': {
                    '()': 'travel.rasp.library.python.common23.logging.JsonFormatter',
                    'keys_to_log': [
                        'timestamp', 'test_buckets', 'req_id', 'icookie', 'yandex_uid', 'user_device',
                        'point_from', 'point_to',
                        'departure_dt', 'arrival_dt',
                        'station_from_geo_id', 'station_to_geo_id',
                        'train_type', 'car_type', 'service_class',
                        'price', 'fee', 'is_bandit_fee_applied',
                        'event_type', 'bandit_type', 'bandit_version',
                    ],
                    'omit_mandatory': True,
                },
            },
            'filters': {
                'require_debug_false': {
                    '()': 'django.utils.log.RequireDebugFalse'
                },
                'context_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.AddContextFilter'
                },
                'context_as_dict_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
                    'as_dict': True,
                },
                'fields_in_context_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.FieldsInContextFilter',
                    'required_fields': ['order_uid']
                },
                'required_bandit_fields_filter': {
                    '()': 'travel.rasp.library.python.common23.logging.RequiredFieldsFilter',
                    'required_fields': ['icookie'],
                },
                'unique_warnings': {
                    '()': 'travel.rasp.library.python.common23.logging.WarningFilterOnce',
                },
            },
            'handlers': {
                'application': {
                    'filters': ['context_filter'],
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, 'application.log'),
                    'formatter': 'context',
                    'level': base_log_level,
                },
                'warnings': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, 'warnings.log'),
                    'formatter': 'simple',
                    'level': base_log_level,
                },
                'exception': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, 'exception.log'),
                    'formatter': 'exception',
                    'level': 'ERROR',
                    'filters': ['context_filter']
                },
                'stdout_application': {
                    'filters': ['context_as_dict_filter'],
                    'class': 'logging.StreamHandler',
                    'stream': 'ext://sys.stdout',
                    'formatter': 'deploy_application',
                },
                'stdout_warnings': {
                    'class': 'logging.StreamHandler',
                    'stream': 'ext://sys.stdout',
                    'formatter': 'deploy_warnings',
                },
                'stderr': {
                    'filters': ['context_as_dict_filter'],
                    'class': 'logging.StreamHandler',
                    'stream': 'ext://sys.stderr',
                    'formatter': 'deploy_errors',
                },
                'train_pricing': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, yt_dir, 'im_trainpricing.log'),
                    'level': base_log_level,
                },
                'yt_order_log': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, yt_dir, 'train_order.log'),
                    'formatter': 'yt_order_log_json',
                },
                'bandit_train_details_log': {
                    'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                    'filename': os.path.join(log_path, yt_dir, 'bandit_train_details.log'),
                    'formatter': 'bandit_train_details_log_json',
                    'filters': ['required_bandit_fields_filter'],
                },
            },
            'loggers': {
                '': {
                    'handlers': ['application', 'stdout_application'],
                    'level': base_log_level,
                },
                'py.warnings': {
                    'filters': ['unique_warnings'],
                    'propagate': False,
                    'handlers': ['warnings', 'stdout_warnings'],
                    'level': base_log_level,
                },
                'django.request': {
                    'handlers': ['exception', 'stderr'],
                    'level': 'ERROR',
                },
                'train_pricing': {
                    'handlers': ['train_pricing'],
                    'level': base_log_level,
                    'propagate': False,
                },
                'yt_order_logger': {
                    'handlers': ['yt_order_log'],
                    'level': base_log_level,
                    'propagate ': False,
                },
                'bandit_train_details_logger': {
                    'handlers': ['bandit_train_details_log'],
                    'level': base_log_level,
                    'propagate ': False,
                },
            },
        }


Configuration.configurator_classes.append(RaspBackendConfigurator)


class TrainApiRedisConfigurator(BaseRedisCacheConfigurator):
    CLUSTER_ID_SECRET = 'REDIS_DEFAULT_CLUSTER_ID'
    CLUSTER_PASSWORD_SECRET = 'REDIS_DEFAULT_PASSWORD'
    CLUSTER_NAME_SECRET = 'REDIS_DEFAULT_NAME'
    CACHE_ALIAS = 'default'
    FALLBACK_HOSTS = {
        'testing': [
            'sas-h2gv1onvhdqshlp3.db.yandex.net',
            'vla-mqf1mt28mvmvqh1q.db.yandex.net'
        ],
        'production': [
            'man-e00rwavsajtwx8zn.db.yandex.net',
            'sas-i66s9ofo00tmpeqm.db.yandex.net',
            'vla-w8i8pn3i12fcx2sq.db.yandex.net'
        ]
    }

    def apply_testing(self, settings):
        self.configure_redis(settings, get_secret('trains-common-testing'))

    def apply_production(self, settings):
        self.configure_redis(settings, get_secret('trains-common-production'))


ENABLE_REDIS_CACHE = bool_converter(os.getenv('RASP_ENABLE_REDIS_CACHE'))
DISABLE_GROUP_CACHES = ENABLE_REDIS_CACHE
if ENABLE_REDIS_CACHE:
    Configuration.configurator_classes.append(TrainApiRedisConfigurator)

BASE_LOG_LEVEL = 'INFO'

if not os.getenv('YA_TEST_RUNNER'):
    Configuration().apply(globals())

    logging.getLogger("common.utils.connectdb").setLevel(logging.WARNING)

    TRUST_COLLECT_METRICS = False

    MYSQL_READ_TIMEOUT = 19
