# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields
from marshmallow_enum import EnumField

from common.serialization.common_schemas import PriceSchema
from common.serialization.fields import DictNestedField, DictField
from travel.rasp.train_api.serialization.fields import FlagField
from travel.rasp.train_api.serialization.segment import BaseSegmentSchema
from travel.rasp.train_api.train_purchase.core.enums import TrainOrderUrlOwner


class OrderRequest(Schema):
    http_method = fields.String(dump_to='httpMethod')
    url = fields.String()
    params = DictField(fields.String())
    headers = DictField(fields.String())


class TariffSchema(Schema):
    price = fields.Nested(PriceSchema)
    service_price = fields.Nested(PriceSchema, dump_to='servicePrice')
    seats = fields.Integer()
    lower_seats = fields.Integer(dump_to='lowerSeats')
    upper_seats = fields.Integer(dump_to='upperSeats')
    lower_side_seats = fields.Integer(dump_to='lowerSideSeats')
    upper_side_seats = fields.Integer(dump_to='upperSideSeats')
    order_url = fields.String(dump_to='orderUrl')
    partner_order_request = fields.Nested(OrderRequest, dump_to='partnerOrderRequest')
    train_order_url = fields.String(dump_to='trainOrderUrl')
    train_order_url_owner = EnumField(TrainOrderUrlOwner, by_value=True, dump_to='trainOrderUrlOwner')
    deep_url = fields.String(dump_to='deepUrl')
    several_prices = FlagField(dump_to='severalPrices')
    has_non_refundable_tariff = fields.Boolean(dump_to='hasNonRefundableTariff')


class SegmentTariffsSchema(Schema):
    classes = DictNestedField(TariffSchema)
    electronic_ticket = FlagField(dump_to='electronicTicket')


class TariffsSegmentSchema(BaseSegmentSchema):
    key = fields.String()
    number = fields.Function(lambda s: s.number if getattr(s, 'show_number', True) else '')
    original_number = fields.String(dump_to='originalNumber')
    tariffs = fields.Nested(SegmentTariffsSchema)
