# coding: utf-8

from __future__ import unicode_literals, absolute_import, division, print_function

from logging import getLogger

from common.utils.date import naive_to_timestamp, UTC_TZ
from travel.rasp.library.python.common23.date.environment import now_utc

bandit_train_details_log = getLogger('bandit_train_details_logger')
log = getLogger(__name__)


def log_segment(segment, query):
    for class_name, tariff in segment.tariffs['classes'].items():
        try:
            data = {
                'timestamp': naive_to_timestamp(now_utc()),
                'test_buckets': query.get('test_buckets'),
                'req_id': query.get('req_id'),
                'icookie': query.get('icookie'),
                'yandex_uid': query.get('yandex_uid'),
                'point_from': segment.station_from.point_key,
                'point_to': segment.station_to.point_key,
                'departure_dt': naive_to_timestamp(segment.departure.astimezone(UTC_TZ).replace(tzinfo=None)),
                'arrival_dt': naive_to_timestamp(segment.arrival.astimezone(UTC_TZ).replace(tzinfo=None)),
                'station_from_id': segment.station_from.id,
                'station_to_id': segment.station_to.id,
                'train_type': segment.raw_train_name,
                'car_type': class_name,
                'service_class': tariff.service_class,
                'price': float(tariff.price.value),
                'fee': float(tariff.fee_percent),
                'event_type': 'train-tariffs',
            }
            bandit_train_details_log.info(msg=None, extra=data)
        except Exception:
            log.exception('Cannot log segment %s. Skipping.', segment.number)
