# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import typing


class CoachCategoryTraits(typing.NamedTuple('CoachCategoryTraits', (
    ('can_choose_male_female_mix_places', bool),
    ('places_without_numbers', bool),
    ('is_not_firm', bool),
    ('pet_in_coach', bool),
    ('pet_places_only', bool),
    ('is_for_children', bool),
))):
    @classmethod
    def loads(cls, raw_traits):
        # type: (typing.Text) -> CoachCategoryTraits
        """
        Признаки категории вагона через пробел.
        "МЖ" - Вагоны с правом выбора мужского, женского или смешанного купе.
        "У[0-7]" - Услуги питания от 0 до 7 раз (в зависимости от времени в пути)
        "НФ" - Нефирменный вагон фирменного поезда
        "БН" - Без номеров мест
        "И" - В вагоне есть места для пассажиров с ограниченными физическими возможностями.
        "Ж" - В вагоне есть места для пассажиров с мелкими домашними животными
        "*Ж" - Места для пассажиров с мелкими домашними животными
        """
        category_traits = set(raw_traits.strip().replace('* ', '*').split())
        return cls(
            can_choose_male_female_mix_places='МЖ' in category_traits,
            places_without_numbers='БН' in category_traits,
            is_not_firm='НФ' in category_traits,
            pet_in_coach='Ж' in category_traits,
            pet_places_only='*Ж' in category_traits,
            is_for_children='*Д' in category_traits,
        )
