# coding: utf-8

from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.utils.encoding import smart_bytes

from common.utils import marketstat
from travel.rasp.library.python.common23.date import environment
from travel.rasp.train_api.tariffs.train.base.utils import TRAIN_KEY_FORMAT, make_time_key
from travel.rasp.train_api.train_purchase.core.enums import TrainPartner

yt_dynamic_tariffs_log = marketstat.DsvSimpleLog(settings.DINAMIC_TARIFFS_LOG)


def log_segment(segment, query):
    timestamp = environment.now_aware()
    for class_name, tariff in segment.tariffs['classes'].items():
        data = {
            'timestamp': timestamp.strftime("%Y-%m-%d %H:%M:%S"),
            'timezone': timestamp.strftime('%z'),
            'class_{}_price'.format(class_name): tariff.price,
            'class_{}_seats'.format(class_name): tariff.seats,
            'fee_percent': tariff.fee_percent,
            'arrival': segment.arrival,
            'departure': segment.departure,
            'date_forward': segment.departure.strftime('%Y-%m-%d'),
            'duration': segment.get_duration(),
            'route_uid': segment.original_number,
            'object_from_id': segment.station_from.id,
            'object_from_title': segment.station_from.L_title(),
            'object_from_type': 'Station',
            'object_to_id': segment.station_to.id,
            'object_to_title': segment.station_to.L_title(),
            'object_to_type': 'Station',
            'type': 'train',
            'adults': '1',
            'tskv_format': 'rasp-tariffs-log',
            'partner': query.get('partner', TrainPartner.IM).value,
            'price_exp_id': query['price_exp_id'],
            'service': query['service'],
            'utm_source': query['utm_source'],
            'yandex_uid': query['yandex_uid'],
            'force_ufs_order': query['force_ufs_order'],
            'key': TRAIN_KEY_FORMAT.format(segment.original_number, make_time_key(segment.departure)),
            'provider': segment.provider,
        }
        data = {smart_bytes(k): smart_bytes(v) for k, v in data.items()}
        yt_dynamic_tariffs_log.log(data)
