# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import datetime

from django.utils import six

from common.models.tariffs import Setting
from common.tester.factories import create_station
from travel.rasp.train_api.tariffs.train.base.models import TrainSegment, TrainTariff, TrainTariffsQuery
from travel.rasp.train_api.tariffs.train.base.worker import TrainTariffsResult
from travel.rasp.train_api.train_purchase.core.models import TrainPartner


def create_train_tariffs_query(
    partner=TrainPartner.IM, departure_point=None, arrival_point=None,
    departure_date='2016-05-01', include_reason_for_missing_prices=True,
    icookie=None, bandit_type=None, mock_im_path=None,
):
    departure_point = departure_point or {'__': {'codes': {'express': '0000000'}}, 't_type': 'train'}
    if isinstance(departure_point, dict):
        departure_point = create_station(**departure_point)

    arrival_point = arrival_point or {'__': {'codes': {'express': '1111111'}}, 't_type': 'train'}
    if isinstance(arrival_point, dict):
        arrival_point = create_station(**arrival_point)

    if isinstance(departure_date, six.string_types):
        departure_date = datetime.strptime(departure_date, '%Y-%m-%d').date()

    return TrainTariffsQuery(
        partner=partner,
        departure_point=departure_point,
        arrival_point=arrival_point,
        departure_date=departure_date,
        include_reason_for_missing_prices=include_reason_for_missing_prices,
        icookie=icookie,
        bandit_type=bandit_type,
        original_query={},
        mock_im_path=mock_im_path,
        mock_im_auto=False,
    )


def create_train_segment(**attrs):
    segment = TrainSegment()
    for attr, value in attrs.items():
        setattr(segment, attr, value)
    return segment


def create_train_tariff(*args, **kwargs):
    fee = kwargs.pop('fee', None)
    tariff = TrainTariff(*args, **kwargs)
    tariff.fee = fee
    return tariff


def create_train_tariffs_result(query=None, status=TrainTariffsResult.STATUS_SUCCESS, segments=None):
    query = query or {}
    if isinstance(query, dict):
        query = create_train_tariffs_query(**query)

    result_segments = []
    if segments is not None:
        for segment in segments:
            if isinstance(segment, dict):
                result_segments.append(create_train_segment(**segment))
            else:
                result_segments.append(segment)

    return TrainTariffsResult(query=query, status=status, segments=result_segments)


def create_www_setting_cache_timeouts(**kwargs):
    www_settings = {
        'UFS_CACHE_TIMEOUT': 10,
        'UFS_NETWORK_ERROR_TIMEOUT': 10,
        'UFS_RESPONSE_ERROR_TIMEOUT': 10,
        'UFS_EMPTY_TIMEOUT': 10,
        'UFS_PARSE_ERROR_TIMEOUT': 10,
    }
    www_settings.update(kwargs)

    for k, v in www_settings.items():
        Setting.objects.create(name='', code=k, value=six.text_type(v), type='int')
