# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import factory
import six

from common.apps.train_order.enums import CoachType
from travel.rasp.library.python.common23.tester.helpers.class_counter import inc_class_counter
from travel.rasp.train_api.helpers.factory import fix_list_subfactory
from travel.rasp.train_api.tariffs.train.base.availability_indication import (
    AvailabilityIndication as TrainAvailabilityIndication
)
from travel.rasp.train_api.tariffs.train.im.parser import IM_AVAILABILITY_INDICATION_TYPES
from travel.rasp.train_api.train_partners.im.base import IM_DATETIME_FORMAT, PROVIDER_P1
from travel.rasp.train_api.train_partners.im.reserve_tickets import COACH_TYPE_TO_CARTYPE_VALUE

AVAILABILITY_INDICATION_TO_AVAILABILITY = {v: k for k, v in IM_AVAILABILITY_INDICATION_TYPES.items()}


def _adjust_dt_arg(arg_name, kwargs):
    value = kwargs.get(arg_name, '')
    if not isinstance(value, six.string_types):
        kwargs[arg_name] = value.strftime(IM_DATETIME_FORMAT)


class ImCarGroupFactory(factory.DictFactory):
    CarType = COACH_TYPE_TO_CARTYPE_VALUE[CoachType.PLATZKARTE]
    PlaceQuantity = 0
    LowerPlaceQuantity = 11
    UpperPlaceQuantity = 8
    LowerSidePlaceQuantity = 0
    UpperSidePlaceQuantity = 0
    MalePlaceQuantity = 0
    FemalePlaceQuantity = 3
    EmptyCabinQuantity = 12
    MixedCabinQuantity = 4
    MinPrice = 1000
    MaxPrice = 2000
    IsSaleForbidden = False
    AvailabilityIndication = AVAILABILITY_INDICATION_TO_AVAILABILITY[TrainAvailabilityIndication.AVAILABLE]
    Carriers = ['ФПК']
    CarDescriptions = ['МЖ Ж']
    ServiceClasses = ['2Л']
    InternationalServiceClasses = []
    ServiceCosts = [161.0]
    IsBeddingSelectionPossible = False
    HasElectronicRegistration = True
    HasGenderCabins = True
    HasPlaceNumeration = True
    HasPlacesNearPlayground = False
    HasPlacesNearPets = True
    HasPlacesNearBabies = False
    HasNonRefundableTariff = False
    Discounts = []
    InfoRequestSchema = 'StandardExcludingInvalids'
    TotalPlaceQuantity = 19
    PlaceReservationTypes = ['Usual']
    IsThreeHoursReservationAvailable = True
    IsMealOptionPossible = False
    IsAdditionalMealOptionPossible = False
    IsOnRequestMealOptionPossible = False
    IsTransitDocumentRequired = False
    IsInterstate = False
    ClientFeeCalculation = None
    AgentFeeCalculation = {'Charge': 31.70, 'Profit': 0.0}

    @classmethod
    def _adjust_kwargs(cls, **kwargs):
        if 'CarType' in kwargs and isinstance(kwargs['CarType'], CoachType):
            kwargs['CarType'] = kwargs['CarType'].im_car_type
        if (
            'AvailabilityIndication' in kwargs
            and isinstance(kwargs['AvailabilityIndication'], TrainAvailabilityIndication)
        ):
            kwargs['AvailabilityIndication'] = AVAILABILITY_INDICATION_TO_AVAILABILITY[kwargs['AvailabilityIndication']]
        return kwargs


class ImTrainFactory(factory.DictFactory):
    HasElectronicRegistration = True
    HasCarTransportationCoaches = False
    HasDynamicPricingCars = True
    HasTwoStoreyCars = False
    Carriers = ['ФПК']
    CarGroups = factory.List([factory.SubFactory(ImCarGroupFactory)])
    Id = factory.LazyAttribute(lambda _x: inc_class_counter(ImTrainFactory, 'Id', start_value=1))
    IsBranded = False
    TrainNumber = '030А'
    TrainNumberToGetRoute = '030А'
    DisplayTrainNumber = '030А'
    TrainDescription = 'СК'
    TrainFrequency = None
    TrainName = ''
    TransportType = 'Train'
    TrainType = 'TrainWithPlaces'
    OriginName = 'МОСКВА ОКТ'
    InitialStationName = 'МОСКВА ОКТ'
    OriginStationCode = '2006004'
    DestinationName = 'С-ПЕТЕР-ГЛ'
    FinalStationName = 'С-ПЕТЕР-ГЛ'
    DestinationStationCode = '2004001'
    DestinationNames = ['С-ПЕТЕР-ГЛ']
    FinalStationNames = ['С-ПЕТЕР-ГЛ']
    DepartureDateTime = '2020-02-25T01:15:00'
    LocalDepartureDateTime = '2020-02-25T01:15:00'
    ArrivalDateTime = '2020-02-25T10:04:00'
    LocalArrivalDateTime = '2020-02-25T10:04:00'
    ArrivalDateTimes = ['2020-02-25T10:04:00']
    LocalArrivalDateTimes = ['2020-02-25T10:04:00']
    DepartureDateFromFormingStation = '2020-02-25T00:00:00'
    DepartureStopTime = 0
    ArrivalStopTime = 0
    TripDuration = 529
    TripDistance = 650
    IsSuburban = False
    IsComponent = False
    CarServices = []
    IsSaleForbidden = False
    IsTicketPrintRequiredForBoarding = False
    BookingSystem = 'Express3'
    Provider = PROVIDER_P1
    IsVrStorageSystem = False

    @classmethod
    def _adjust_kwargs(cls, **kwargs):
        for arg_name in ('DepartureDateTime', 'LocalDepartureDateTime', 'DepartureDateFromFormingStation',
                         'ArrivalDateTime', 'LocalArrivalDateTime'):
            _adjust_dt_arg(arg_name, kwargs)
        return kwargs

    @classmethod
    def create(cls, **kwargs):
        fix_list_subfactory('CarGroups', ImCarGroupFactory, kwargs)
        return super(ImTrainFactory, cls).create(**kwargs)


class ImTrainPricingResponseFactory(factory.DictFactory):
    RoutePolicy = 'Internal'
    OriginCode = '2000000'
    OriginStationCode = '2006004'
    OriginTimeZoneDifference = 0
    DestinationCode = '2004000'
    DestinationStationCode = '2004001'
    DestinationTimeZoneDifference = 0
    Trains = factory.List([factory.SubFactory(ImTrainFactory)])
    DepartureTimeDescription = 'Moscow'
    ArrivalTimeDescription = 'Moscow'
    IsFromUkrain = False
    ClientFeeCalculation = None
    AgentFeeCalculation = {'Charge': 31.70, 'Profit': 0.0}
    NotAllTrainsReturned = False
    StationClarifying = None
    BookingSystem = 'Express3'
    Id = factory.LazyAttribute(lambda _x: inc_class_counter(ImTrainPricingResponseFactory, 'Id', start_value=0))

    @classmethod
    def create(cls, **kwargs):
        fix_list_subfactory('Trains', ImTrainFactory, kwargs)
        return super(ImTrainPricingResponseFactory, cls).create(**kwargs)
