# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from functools import reduce

from common.apps.train.models import UFSNewOrderBlackList
from common.models.transport import TransportType


def redirect_blacklisted_trains_to_ufs(segments):
    black_list_numbers = get_ufs_black_list_train_numbers()

    for s in segments:
        if s.thread and s.thread.t_type_id == TransportType.TRAIN_ID and s.thread.number in black_list_numbers:
            s.old_ufs_order = True

    return segments


def get_ufs_black_list_train_numbers():
    return reduce(
        lambda set1, set2: set1 | set2,
        (bl.numbers for bl in UFSNewOrderBlackList.objects.all()),
        set()
    )
