# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from common.dynamic_settings.default import conf
from common.utils.namedtuple import namedtuple_with_defaults

AGRYZ_ID = 20012
ANAPA_ID = 1107
ARHANGELSK_ID = 20
BAKU_ID = 10253
BALAKOVO_ID = 11143
BARANOVICHY_ID = 21015
BARNAUL_ID = 197
BELGOROD_ID = 4
BREST_ID = 153
CHEBOKSARY_ID = 45
CHELYABINSK_ID = 56
DNEPR_ID = DNEPROPETROVSK_ID = 141
GOMEL_ID = 155
GRODNO_ID = 10274
IZHEVSK_ID = 44
KAZAN_ID = 43
KHARKOV_ID = 147
KHMELNICKIY_ID = 961
KIEV_ID = 143
KIROV_ID = 46
KISHINEV_ID = 10313
KISLOVODSK_ID = 11062
KOVEL_ID = 23035
KRASNOUFIMSK_ID = 20691
KRASNOYARSK_ID = 62
KRIVOY_ROG_ID = 10347
LVOV_ID = 144
MAKHACHKALA_ID = 28
MINERALNIYE_VODI_ID = 11063
MINSK_ID = 157
MOSCOW_ID = 213
MURMANSK_ID = 23
NIKOLAEV_ID = 148
NIZHNEVARTOVSK_ID = 1091
NIZHNY_NOVGOROD_ID = 23243
NOVIY_URENGOY_ID = 11230
NOVOKUZNETSK_ID = 237
NOVOROSSIYSK_ID = 970
NOVOSIBIRSK_ID = 65
ODESSA_ID = 145
OMSK_ID = 66
OREL_ID = 10
ORENBURG_ID = 48
ORSK_ID = 11091
PECHORA_ID = 10942
PENZA_ID = 49
PERM_ID = 50
POLOCK_ID = 10275
RIGA_ID = 11474
ROSTOV_NA_DONU_ID = 39
SAMARA_ID = 51
SARANSK_ID = 42
SARATOV_ID = 194
SMOLENSK_ID = 12
SOCHI_ID = 239
SPB_ID = 2
SYKTYVKAR_ID = 19
TAGANROG_ID = 971
TALLIN_ID = 11481
TYUMEN_ID = 55
UFA_ID = 172
ULYANOVSK_ID = 195
USINSK_ID = 10944
VLADIKAVKAZ_ID = 33
VOLOGDA_ID = 21
VORKUTA_ID = 10940
YEKATERINBURG_ID = 54
ZHMERINKA_ID = 22884

SalesDepthRule = namedtuple_with_defaults(
    'DepthOfSalesRule',
    ('start_settlement_id', 'end_settlement_id', 'numbers', 'sales_depth', 'both_directions'),
    defaults={'both_directions': True}
)
SalesDepthKey = namedtuple('DepthOfSalesKey', ('start_settlement_id', 'end_settlement_id', 'number'))

SUBURBAN_SALES_DEPTH = 10
SALES_DEPTH_RULES = (
    SalesDepthRule(MOSCOW_ID, SPB_ID, ('003', '004'), 120),

    SalesDepthRule(MOSCOW_ID, KIEV_ID, ('005', '006'), 45),
    SalesDepthRule(KHARKOV_ID, MOSCOW_ID, ('019', '020'), 45),
    SalesDepthRule(ODESSA_ID, MOSCOW_ID, ('023', '024'), 45),
    SalesDepthRule(KIEV_ID, SPB_ID, ('053', '054', '143', '144'), 45),
    SalesDepthRule(KHARKOV_ID, SPB_ID, ('053', '054', '143', '144'), 45),
    SalesDepthRule(MOSCOW_ID, KHMELNICKIY_ID, ('055', '056', '089', '090'), 45),
    SalesDepthRule(MOSCOW_ID, ZHMERINKA_ID, ('055', '056', '089', '090'), 45),
    SalesDepthRule(NIKOLAEV_ID, MOSCOW_ID, ('061', '062'), 45),
    SalesDepthRule(LVOV_ID, MOSCOW_ID, ('073', '074', '077', '078'), 45),
    SalesDepthRule(KOVEL_ID, MOSCOW_ID, ('073', '074', '077', '078'), 45),
    SalesDepthRule(KRIVOY_ROG_ID, MOSCOW_ID, ('073', '074', '105', '106'), 45),
    SalesDepthRule(DNEPR_ID, MOSCOW_ID, ('095', '096', '105', '106'), 45),
    SalesDepthRule(BAKU_ID, KHARKOV_ID, ('369', '370'), 45),

    SalesDepthRule(KISHINEV_ID, MOSCOW_ID, ('047', '048', '065', '066', '341', '342'), 45),
    SalesDepthRule(KISHINEV_ID, SPB_ID, ('061', '062'), 45),

    SalesDepthRule(MINSK_ID, MOSCOW_ID, ('001', '002', '025', '026'), 60),
    SalesDepthRule(BREST_ID, MOSCOW_ID, ('027', '028'), 60),
    SalesDepthRule(BREST_ID, SPB_ID, ('049', '050'), 60),
    SalesDepthRule(MINSK_ID, NOVOSIBIRSK_ID, ('063', '064'), 60),
    SalesDepthRule(MINSK_ID, MURMANSK_ID, ('065', '066'), 60),
    SalesDepthRule(BREST_ID, SARATOV_ID, ('067', '068'), 60),
    SalesDepthRule(GRODNO_ID, MOSCOW_ID, ('077', '078'), 60),
    SalesDepthRule(BREST_ID, MOSCOW_ID, ('003', '004', '007', '008', '095', '096'), 60),
    SalesDepthRule(BREST_ID, NOVOSIBIRSK_ID, ('103', '104'), 60),
    SalesDepthRule(BREST_ID, MOSCOW_ID, ('131', '132'), 60),
    SalesDepthRule(MINSK_ID, ARHANGELSK_ID, ('133', '134'), 60),
    SalesDepthRule(MOSCOW_ID, TALLIN_ID, ('033', '034'), 60),
    SalesDepthRule(MOSCOW_ID, POLOCK_ID, ('039', '040'), 60),
    SalesDepthRule(MINSK_ID, SPB_ID, ('051', '052'), 60),
    SalesDepthRule(MOSCOW_ID, GOMEL_ID, ('055', '056'), 60),
    SalesDepthRule(RIGA_ID, MOSCOW_ID, ('001', '002'), 60),
    SalesDepthRule(RIGA_ID, SPB_ID, ('001', '002'), 60),
    SalesDepthRule(GOMEL_ID, SPB_ID, ('083', '084'), 60),
    SalesDepthRule(BARANOVICHY_ID, SARATOV_ID, ('307', '308'), 60),
    SalesDepthRule(MINSK_ID, KAZAN_ID, ('327', '328'), 60),
    SalesDepthRule(MINSK_ID, SPB_ID, ('249', '250'), 60),

    # TRAINS-5705: Updates from 13.05.20
    SalesDepthRule(KAZAN_ID, MOSCOW_ID, ('001', '002'), 90),
    SalesDepthRule(
        SPB_ID, MOSCOW_ID,
        ('001', '002', '005', '006', '751', '752', '755', '756', '773', '774', '777', '778'),
        90,
    ),
    SalesDepthRule(KISLOVODSK_ID, MOSCOW_ID, ('003', '004'), 120),
    SalesDepthRule(SAMARA_ID, MOSCOW_ID, ('009', '010'), 90),
    SalesDepthRule(ANAPA_ID, MOSCOW_ID, ('011', '012'), 120),
    SalesDepthRule(SARATOV_ID, SOCHI_ID, ('013', '014'), 90),
    SalesDepthRule(MURMANSK_ID, MOSCOW_ID, ('015', '016', '241', '242'), 90),
    SalesDepthRule(MURMANSK_ID, BELGOROD_ID, ('015', '016'), 90),
    SalesDepthRule(MURMANSK_ID, SMOLENSK_ID, ('015', '016'), 90),
    SalesDepthRule(ROSTOV_NA_DONU_ID, MOSCOW_ID, ('019', '020'), 120),
    SalesDepthRule(TAGANROG_ID, MOSCOW_ID, ('019', '020'), 90),
    SalesDepthRule(KAZAN_ID, MOSCOW_ID, ('023', '024'), 120),
    SalesDepthRule(NOVOROSSIYSK_ID, MOSCOW_ID, ('023', '024'), 90),
    SalesDepthRule(NOVOROSSIYSK_ID, MOSCOW_ID, ('029', '030'), 120),
    SalesDepthRule(SPB_ID, SOCHI_ID, ('035', '036'), 120),
    SalesDepthRule(SARANSK_ID, MOSCOW_ID, ('041', '042'), 120),
    SalesDepthRule(BALAKOVO_ID, MOSCOW_ID, ('047', '048'), 90),
    SalesDepthRule(KISLOVODSK_ID, SPB_ID, ('049', '050'), 90),
    SalesDepthRule(CHEBOKSARY_ID, MOSCOW_ID, ('053', '054'), 90),
    SalesDepthRule(NOVOKUZNETSK_ID, KISLOVODSK_ID, ('059', '060'), 90),
    SalesDepthRule(OMSK_ID, KISLOVODSK_ID, ('059', '060'), 90),
    SalesDepthRule(OMSK_ID, UFA_ID, ('059', '060'), 90),
    SalesDepthRule(ARHANGELSK_ID, SOCHI_ID, ('079', '080'), 90),
    SalesDepthRule(VOLOGDA_ID, SOCHI_ID, ('079', '080'), 90),
    SalesDepthRule(NIZHNY_NOVGOROD_ID, SOCHI_ID, ('087', '088'), 90),
    SalesDepthRule(SMOLENSK_ID, SPB_ID, ('087', '088'), 90),
    SalesDepthRule(NIZHNY_NOVGOROD_ID, VORKUTA_ID, ('089', '090'), 90),
    SalesDepthRule(NIZHNY_NOVGOROD_ID, KIROV_ID, ('089', '090'), 90),
    SalesDepthRule(NIZHNY_NOVGOROD_ID, USINSK_ID, ('089', '090'), 90),
    SalesDepthRule(KIROV_ID, USINSK_ID, ('089', '090'), 90),
    SalesDepthRule(SOCHI_ID, MOSCOW_ID, ('101', '102', '103', '104'), 120),
    SalesDepthRule(TAGANROG_ID, ROSTOV_NA_DONU_ID, ('119', '120'), 90),
    SalesDepthRule(BELGOROD_ID, SPB_ID, ('119', '120'), 90),
    SalesDepthRule(OREL_ID, SPB_ID, ('119', '120'), 90),
    SalesDepthRule(KRASNOYARSK_ID, SOCHI_ID, ('127', '128'), 90),
    SalesDepthRule(UFA_ID, SOCHI_ID, ('127', '128'), 90),
    SalesDepthRule(SAMARA_ID, SOCHI_ID, ('127', '128'), 90),
    SalesDepthRule(KRASNOYARSK_ID, ANAPA_ID, ['129'], 90),
    SalesDepthRule(ORSK_ID, MOSCOW_ID, ('131', '132'), 90),
    SalesDepthRule(ORENBURG_ID, MOSCOW_ID, ('131', '132'), 90),
    SalesDepthRule(MAKHACHKALA_ID, SPB_ID, ('135', '136'), 90),
    SalesDepthRule(VLADIKAVKAZ_ID, SPB_ID, ('135', '136'), 90),
    SalesDepthRule(ORENBURG_ID, MOSCOW_ID, ('137', '138'), 90),
    SalesDepthRule(SAMARA_ID, MOSCOW_ID, ('137', '138'), 90),
    SalesDepthRule(BARNAUL_ID, SOCHI_ID, ('139', '140'), 90),
    SalesDepthRule(PENZA_ID, SOCHI_ID, ('139', '140'), 90),
    SalesDepthRule(NOVOSIBIRSK_ID, SOCHI_ID, ('139', '140'), 90),
    SalesDepthRule(OMSK_ID, SOCHI_ID, ('139', '140'), 90),
    SalesDepthRule(SYKTYVKAR_ID, USINSK_ID, ('305', '306'), 90),
    SalesDepthRule(PERM_ID, NOVOROSSIYSK_ID, ('325', '326'), 90),
    SalesDepthRule(UFA_ID, NOVIY_URENGOY_ID, ('331', '332'), 90),
    SalesDepthRule(SAMARA_ID, NOVIY_URENGOY_ID, ('331', '332'), 90),
    SalesDepthRule(YEKATERINBURG_ID, NOVOROSSIYSK_ID, ('335', '336'), 90),
    SalesDepthRule(NIZHNY_NOVGOROD_ID, NOVOROSSIYSK_ID, ('339', '340'), 90),
    SalesDepthRule(CHELYABINSK_ID, SOCHI_ID, ('343', '344'), 90),
    SalesDepthRule(ORSK_ID, SOCHI_ID, ('343', '344'), 90),
    SalesDepthRule(ORENBURG_ID, SOCHI_ID, ('343', '344'), 90),
    SalesDepthRule(NIZHNEVARTOVSK_ID, SOCHI_ID, ('345', '346'), 90),
    SalesDepthRule(PERM_ID, SOCHI_ID, ('353', '354'), 90),
    SalesDepthRule(ULYANOVSK_ID, SOCHI_ID, ('353', '354'), 90),
    SalesDepthRule(NOVIY_URENGOY_ID, KAZAN_ID, ('377', '378'), 90),
    SalesDepthRule(NOVIY_URENGOY_ID, IZHEVSK_ID, ('377', '378'), 90),
    SalesDepthRule(NOVIY_URENGOY_ID, TYUMEN_ID, ('377', '378'), 90),
    SalesDepthRule(VORKUTA_ID, SOCHI_ID, ('309', '310'), 90),
    SalesDepthRule(VORKUTA_ID, NOVOROSSIYSK_ID, ('309', '310'), 90),
    SalesDepthRule(USINSK_ID, SOCHI_ID, ('309', '310'), 90),
    SalesDepthRule(ROSTOV_NA_DONU_ID, NOVOROSSIYSK_ID, ('311', '312'), 90),
    SalesDepthRule(KIROV_ID, KISLOVODSK_ID, ('367', '368'), 90),
    SalesDepthRule(VLADIKAVKAZ_ID, MINERALNIYE_VODI_ID, ('621', '622'), 90),
    SalesDepthRule(PECHORA_ID, USINSK_ID, ('691', '692'), 90),
    SalesDepthRule(IZHEVSK_ID, KRASNOUFIMSK_ID, ('137', '697', '698'), 90),
    SalesDepthRule(IZHEVSK_ID, AGRYZ_ID, ('137', '697', '698'), 90),
    SalesDepthRule(IZHEVSK_ID, NOVIY_URENGOY_ID, ('137', '697', '698'), 90),
)


class SalesDepthManager(object):
    def __init__(self, sales_depth_rules=None,
                 suburban_sales_depth=SUBURBAN_SALES_DEPTH):
        if sales_depth_rules is None:
            sales_depth_rules = SALES_DEPTH_RULES
        self.suburban_sales_depth = suburban_sales_depth

        self.sales_depth = self._build_sales_depth(sales_depth_rules)

    @staticmethod
    def _build_sales_depth(sales_depth_rules):
        sales_depth = {}
        for rule in sales_depth_rules:
            for number in rule.numbers:
                sales_depth[SalesDepthKey(rule.start_settlement_id, rule.end_settlement_id, number)] = rule.sales_depth
                if rule.both_directions:
                    sales_depth[SalesDepthKey(rule.end_settlement_id, rule.start_settlement_id, number)] = rule.sales_depth
        return sales_depth

    def get_sales_depth(self, segment):
        digital_number = digits_only(segment.number)
        if segment.is_suburban or self._is_suburban_number(digital_number):
            return self.suburban_sales_depth

        start_settlement_id = segment.start_station and segment.start_station.settlement_id
        end_settlement_id = segment.end_station and segment.end_station.settlement_id
        if not start_settlement_id or not end_settlement_id:
            return None

        return self.sales_depth.get(SalesDepthKey(
            segment.start_station.settlement_id,
            segment.end_station.settlement_id,
            digital_number
        )) or conf.TRAIN_PURCHASE_SOLD_OUT_DEFAULT_SALES_DEPTH

    @staticmethod
    def _is_suburban_number(digital_number):
        if len(digital_number) == 3 and digital_number.startswith('8'):
            return True
        if len(digital_number) == 4 and digital_number.startswith('70'):
            return True
        return False


sales_depth_manager = SalesDepthManager()


def digits_only(number):
    i = 0
    size = len(number)
    while i < size and number[i].isdigit():
        i += 1
    return number[0:i]
