PY2_LIBRARY(train_purchase_tests)

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/httpretty
    contrib/python/PyHamcrest

    travel/rasp/train_api
)

TEST_SRCS(
    __init__.py
    core/__init__.py
    core/models/__init__.py
    core/models/test_all.py
    core/models/test_order.py
    core/models/test_query_set_with_collation.py
    core/models/test_refund_email.py
    core/models/test_trainpurchasesmsverification.py
    core/test_enums.py
    core/test_utils.py
    tasks/__init__.py
    tasks/finish_refund_payment/__init__.py
    tasks/finish_refund_payment/test_retry.py
    tasks/finish_refund_payment/test_send_fail_email.py
    tasks/finish_refund_payment/test_update_from_billing.py
    tasks/test_cancel_expired_orders.py
    tasks/test_check_balance.py
    tasks/test_check_office_refunds.py
    tasks/test_clear_payments.py
    tasks/test_client_contracts.py
    tasks/test_collect_expired_orders.py
    tasks/test_collect_refund_blanks.py
    tasks/test_fill_payment_status_and_response.py
    tasks/test_long_external_event_email.py
    tasks/test_refund_email.py
    tasks/test_revivers.py
    tasks/test_unhandled_exception_order.py
    tasks/test_unhandled_exception_refund.py
    tasks/test_unhold_invalid_payments.py
    test_serialization.py
    utils/__init__.py
    utils/test_decorators.py
    utils/test_electronic_registration.py
    utils/test_email_sender_callback.py
    utils/test_fee_calculator.py
    utils/test_order.py
    utils/test_order_tickets.py
    utils/test_order_tickets_boarding_age.py
    utils/test_pagination.py
    utils/test_refund_email.py
    utils/test_sms_verification.py
    utils/test_tickets_email.py
    utils/test_tickets_sms.py
    utils/test_tvm.py
    views/__init__.py
    views/cpa/__init__.py
    views/cpa/test_serialization.py
    views/cpa/test_views.py
    views/insurance/__init__.py
    views/insurance/test_checkout.py
    views/test_cancel_order.py
    views/test_find_order.py
    views/test_refund_order.py
    views/test_retrive_order.py
    views/test_retry_payment.py
    views/test_run_booking.py
    views/test_user_orders.py
    views/test_views.py
    views/travel/__init__.py
    views/travel/test_calculate_tickets_fee.py
    views/travel/test_order_auth_details.py
    views_async/__init__.py
    views_async/test_calculate_refund_amount.py
    views_async/test_change_registration_status.py
    views_async/test_download_blank.py
    views_async/test_im_train_details.py
    views_async/test_log_bandit.py
    views_async/test_order_tickets.py
    views_async/test_prolong_reservation.py
    views_async/test_retrive_order.py
    views_async/test_schedule.py
    views_async/test_takeout_orders.py
    views_async/test_update_tickets_status.py
)

NO_CHECK_IMPORTS()

END()
