# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.namedtuple import namedtuple_with_defaults

ConfirmResult = namedtuple_with_defaults('ConfirmResult', ('expire_set_er', 'order_num', 'insurances_results'))


def confirm_order(order, site_fee=0, timeout=None):
    from travel.rasp.train_api.train_partners import get_partner_api

    api = get_partner_api(order.partner)

    return api.confirm_order(order, site_fee=site_fee, timeout=timeout)


def cancel_order(order, partner_data=None, timeout=None):
    from travel.rasp.train_api.train_partners import get_partner_api

    api = get_partner_api(order.partner)
    api.cancel_order(order, partner_data, timeout=timeout)
