# coding: utf8

from __future__ import unicode_literals, absolute_import, division, print_function

from common.dynamic_settings.default import conf

from travel.rasp.train_api.train_partners.base.train_details.coach_schemas import ProtoSchemaProxy
from travel.rasp.train_api.train_partners.base.train_details.models import CoachSchema


def create_usual_compartment_schema():
    """
    Стандартный купейный вагон (для тестов - укороченный вариант).
                ______________________
    верх       | 9 | 2  4 | 6  8 | WC |
    низ        | 10| 1  3 | 5  7 |____|
               |-  ---  -----  --     |
               |                      |
                ----------------------
    """
    if conf.TRAIN_BACKEND_USE_PROTOBUFS['schemas']:
        return ProtoSchemaProxy.create(
            Id=1000,
            Name='Купе (10 мест)',
            Places='1,2,3,4,5,6,7,8,9,10',
            Details='{"placeFlags": {"upper": [2, 4, 6, 8, 10]}}'
        )
    return CoachSchema.objects.create(
        name='Купе (10 мест)',
        _schema='1,0,0\n'
                '2,0,0\n'
                '3,0,0\n'
                '4,0,0\n'
                '5,0,0\n'
                '6,0,0\n'
                '7,0,0\n'
                '8,0,0\n'
                '9,0,0\n'
                '10,0,0\n',
        details='{"placeFlags": {"upper": [2, 4, 6, 8, 10]}}'
    )


def create_kryukov_compartment_schema():
    """
    Купейный вагон Крюковского завода (для тестов - укороченный вариант).
                _________________________
    верх       | 2  4 | 6  8 | 9  10| WC |
    низ        | 1  3 | 5  7 | 11 12|____|
               |--  -----  ---------     |
               |                         |
                -------------------------
    """
    if conf.TRAIN_BACKEND_USE_PROTOBUFS['schemas']:
        return ProtoSchemaProxy.create(
            Id=1001,
            Name='Крюковское купе (12 мест)',
            Places='1,2,3,4,5,6,7,8,9,10,11,12',
            Details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12]}}'
        )
    return CoachSchema.objects.create(
        name='Крюковское купе (12 мест)',
        _schema='1,0,0\n'
                '2,0,0\n'
                '3,0,0\n'
                '4,0,0\n'
                '5,0,0\n'
                '6,0,0\n'
                '7,0,0\n'
                '8,0,0\n'
                '9,0,0\n'
                '10,0,0\n'
                '11,0,0\n'
                '12,0,0\n',
        details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12]}}'
    )


def create_usual_platzkarte_schema():
    """
    Стандартный плацкарт (для тестов - укороченный вариант).
                ____________________________
    верх       |  2  4 |  6  8 | 10 12 | WC |
    низ        |  1  3 |  5  7 |  9 11 |____|
               |                            |
    верх бок   |   18  |   16  |   14  |    |
    низ бок    |   17  |   15  |   13  |    |
                ----------------------------
    """
    if conf.TRAIN_BACKEND_USE_PROTOBUFS['schemas']:
        return ProtoSchemaProxy.create(
            Id=1002,
            Name='Плацкарт (18 мест)',
            Places='1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18',
            Details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12, 14, 16, 18], "side": [13, 14, 15, 16, 17, 18], '
                    '"nearToilet": [9, 10, 11, 12, 13, 14]}}'
        )
    return CoachSchema.objects.create(
        name='Плацкарт (18 мест)',
        _schema='1,0,0\n'
                '2,0,0\n'
                '3,0,0\n'
                '4,0,0\n'
                '5,0,0\n'
                '6,0,0\n'
                '7,0,0\n'
                '8,0,0\n'
                '9,0,0\n'
                '10,0,0\n'
                '11,0,0\n'
                '12,0,0\n'
                '13,0,0\n'
                '14,0,0\n'
                '15,0,0\n'
                '16,0,0\n'
                '17,0,0\n'
                '18,0,0\n',
        details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12, 14, 16, 18], "side": [13, 14, 15, 16, 17, 18], '
                '"nearToilet": [9, 10, 11, 12, 13, 14]}}'
    )


def create_kryukov_platzkarte_schema():
    """
    Крюковский плацкарт (для тестов - укороченный вариант).
                ____________________________________
    верх       |  2  4 |  6  8 | 10 12 | 14 16 | WC |
    низ        |  1  3 |  5  7 |  9 11 | 13 15 |____|
               |                                    |
    верх бок   |   22  |   20  |   18  |            |
    низ бок    |   21  |   19  |   17  |            |
                ------------------------------------
    """
    if conf.TRAIN_BACKEND_USE_PROTOBUFS['schemas']:
        return ProtoSchemaProxy.create(
            Id=1003,
            Name='Крюковский плацкарт (22 мест)',
            Places='1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22',
            Details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22], '
                    '"side": [17, 18, 19, 20, 21, 22], "nearToilet": [13, 14, 15, 16]}}'
        )
    return CoachSchema.objects.create(
        name='Крюковский пдацкарт (22 мест)',
        _schema='1,0,0\n'
                '2,0,0\n'
                '3,0,0\n'
                '4,0,0\n'
                '5,0,0\n'
                '6,0,0\n'
                '7,0,0\n'
                '8,0,0\n'
                '9,0,0\n'
                '10,0,0\n'
                '11,0,0\n'
                '12,0,0\n'
                '13,0,0\n'
                '14,0,0\n'
                '15,0,0\n'
                '16,0,0\n'
                '17,0,0\n'
                '18,0,0\n'
                '19,0,0\n'
                '20,0,0\n'
                '21,0,0\n'
                '22,0,0\n',
        details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22], '
                '"side": [17, 18, 19, 20, 21, 22], '
                '"nearToilet": [13, 14, 15, 16]}}'
    )


def create_suite_schema():
    """
    СВ, 16 мест с верхними
                ________________________________
    верх       |  2  4 |  6  8 | 10 12 | 14 16  |
    низ        |  1  3 |  5  7 |  9 11 | 13 15  |
               |                                |
                --------------------------------
    """
    if conf.TRAIN_BACKEND_USE_PROTOBUFS['schemas']:
        return ProtoSchemaProxy.create(
            Id=1004,
            Name='СВ, 16 мест с верхними',
            Places='1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16',
            Details='{"placeFlags": {"upper": [2, 4, 6, 8, 10, 12, 14, 16], '
                    '"compartments": [[1, 2], [3, 4], [5, 6], [7, 8], [9, 10], [11, 12], [13, 14], [15, 16]]}}'
        )
    return CoachSchema.objects.create(
        name='СВ, 16 мест с верхними',
        _schema='''\
1,185,103,29,9
2,185,80,29,5
3,251,103,39,9
4,251,80,39,5
5,318,103,49,9
6,318,80,49,5
7,384,103,59,9
8,384,80,59,5
9,450,103,69,9
10,450,80,69,5
11,516,103,79,9
12,516,80,79,5
13,582,103,89,9
14,582,80,89,5
15,647,103,99,9
16,647,80,99,5
''',
        _place_groups='1,2\n'
                      '3,4\n'
                      '5,6\n'
                      '7,8\n'
                      '9,10\n'
                      '11,12\n'
                      '13,14\n'
                      '15,16\n',
        details='''{
            "placeFlags":
                {
                    "upper": [2, 4, 6, 8, 10, 12, 14, 16],
                    "compartments": [[1, 2], [3, 4], [5, 6], [7, 8], [9, 10], [11, 12], [13, 14], [15, 16]]
                }
        }'''
    )
