# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

log = logging.getLogger(__name__)


class TicketInfo(object):
    def __init__(self, blank_id, rzhd_status, amount, pending,
                 refund_blank_id=None, refund_operation_id=None, is_external=False, refund_amount=None):
        self.blank_id = blank_id
        self.rzhd_status = rzhd_status
        self.amount = amount
        self.pending = pending
        self.refund_blank_id = refund_blank_id
        self.refund_operation_id = refund_operation_id
        self.is_external = is_external
        self.refund_amount = refund_amount


class InsuranceInfo(object):
    def __init__(self, operation_id, amount, customer_id, operation_status, reference_id,
                 refund_operation_id=None, is_external=False, refund_amount=None):
        self.operation_id = operation_id
        self.amount = amount
        self.customer_id = customer_id
        self.operation_status = operation_status
        self.reference_id = reference_id
        self.refund_operation_id = refund_operation_id
        self.is_external = is_external
        self.refund_amount = refund_amount


class PassengerInfo(object):
    def __init__(self, blank_id, doc_id, refund_blank_id=None, birth_date=None, customer_id=None):
        self.blank_id = blank_id
        self.doc_id = doc_id
        self.refund_blank_id = refund_blank_id
        self.birth_date = birth_date
        self.customer_id = customer_id


class OrderInfoResult(object):
    def __init__(self, buy_operation_id, expire_set_er, status, order_num,
                 tickets=None, passengers=None, insurances=None, reserved_to=None):
        self.buy_operation_id = buy_operation_id
        self.expire_set_er = expire_set_er
        self.status = status
        self.order_num = order_num
        self.tickets = tickets or []  # type: list[TicketInfo]
        self.insurances = insurances or []  # type: list[InsuranceInfo]
        self.passengers = passengers or []  # type: list[PassengerInfo]
        self.reserved_to = reserved_to


def get_order_info(order, timeout=None):
    """
    Это запрос в кэш партнера, поэтому его можно делать [относительно] часто
    :rtype OrderInfoResult:
    """
    from travel.rasp.train_api.train_partners import get_partner_api

    api = get_partner_api(order.partner)

    return api.get_order_info(order, timeout=timeout)


def get_order_info_by_reference_id(order, reference_id):
    from travel.rasp.train_api.train_partners import get_partner_api

    api = get_partner_api(order.partner)
    return api.get_order_info_by_reference_id(order, reference_id)
