# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.train_api.train_partners.base import PartnerError
from travel.rasp.train_api.train_purchase.core.enums import TrainPartner

log = logging.getLogger(__name__)


class RouteInfo(object):
    def __init__(self, first_stop, last_stop):
        self.first_stop = first_stop
        self.last_stop = last_stop


class RouteStopInfo(object):
    def __init__(self, station_express_code, station_name, departure_datetime):
        self.station_express_code = station_express_code
        self.station_name = station_name
        self.departure_datetime = departure_datetime


def get_route_info_for_order(order, timeout=None):
    """
    Получаем информацию о маршруте(ах) поездов
    :param order: заказ morda_backend.train_purchase.core.models.TrainOrder
    :param timeout: таймаут запроса в сек.
    :return: type RouteInfo
    """
    from travel.rasp.train_api.train_partners import get_partner_api

    if order.partner != TrainPartner.IM:
        log.error('get_route_info_for_order не реализован для %s', order.partner)
        return None

    api = get_partner_api(order.partner)
    try:
        return api.get_route_info_for_order(order, timeout)
    except PartnerError:
        log.exception('Ошибка получения начальной станции поезда')
        return None
