# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api.train_purchase.core.enums import TrainPartner


class InsuranceCheckoutException(Exception):
    pass


def checkout(order, timeout=None):
    """
    Формируем покупку страховки
    :param order: заказ train_api.train_purchase.core.models.TrainOrder
    :param timeout: время запроса в сек.
    """
    from travel.rasp.train_api.train_partners import get_partner_api

    if order.partner != TrainPartner.IM:
        raise NotImplementedError('checkout не реализован для {}'.format(order.partner))

    api = get_partner_api(order.partner)
    operation_id_by_customer_id = api.insurance_checkout(order, timeout=timeout)

    for passenger in order.passengers:
        passenger.insurance.operation_id = operation_id_by_customer_id[passenger.customer_id]

    order.save()
