# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api.train_purchase.core.enums import TrainPartner
from travel.rasp.train_api.train_purchase.core.models import Insurance


class InsurancePricingException(Exception):
    pass


class InsurancePricingResult(object):
    def __init__(self, customer_id, amount, package, provider, company, compensation):
        self.customer_id = customer_id
        self.amount = amount
        self.package = package
        self.provider = provider
        self.company = company
        self.compensation = compensation


def pricing(order, timeout=None):
    """
    Получаем информацию о доступных страховых продуктах для заказа
    :param order: заказ train_api.train_purchase.core.models.TrainOrder
    :param timeout: таймаут запроса в сек.
    """
    from travel.rasp.train_api.train_partners import get_partner_api

    if order.partner != TrainPartner.IM:
        raise NotImplementedError('pricing не реализован для {}'.format(order.partner))

    api = get_partner_api(order.partner)
    pricing_results = api.insurance_pricing(order, timeout=timeout)

    pricing_results_by_customer_id = {result.customer_id: result for result in pricing_results}
    for passenger in order.passengers:
        result = pricing_results_by_customer_id[passenger.customer_id]
        passenger.insurance = Insurance(
            amount=result.amount,
            package=result.package,
            provider=result.provider,
            company=result.company,
            compensation=result.compensation,
        )

    order.save()
