# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.utils.exceptions import SimpleUnicodeException
from travel.rasp.train_api.train_purchase.core.enums import TrainPartner

log = logging.getLogger(__name__)

MINIMUM_RESERVATION_MINUTES = 15


class ProlongReservationType(object):
    THREE_HOURS = 'three_hours'


class ProlongReservationError(SimpleUnicodeException):
    pass


def prolong_reservation(order, prolong_reservation_type=ProlongReservationType.THREE_HOURS):
    """
    :param order: заказ train_api.train_purchase.core.models.TrainOrder
    :param prolong_reservation_type: тип продления брони ProlongReservationType
    :return: время (aware) до которого забронированны места
    """
    from travel.rasp.train_api.train_partners import get_partner_api

    if order.partner != TrainPartner.IM:
        raise ProlongReservationError('Продление бронирования не реализовано для {}'.format(order.partner))

    api = get_partner_api(order.partner)

    return api.prolong_reservation(order, prolong_reservation_type=prolong_reservation_type)
