# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.namedtuple import namedtuple_with_defaults

TIME_NOTICE_MARKER = 'ВРЕМЯ '
RESERVE_TICKET_ENDPOINT_NAME = 'reserve_tickets'

ReserveRequestPassenger = namedtuple_with_defaults('ReserveRequestPassenger', (
    'age_group',
    'birth_date',
    'citizenship_country',
    'document_number',
    'document_type',
    'first_name',
    'gender',
    'last_name',
    'loyalty_cards',
    'patronymic',
    'tariff_info',
    'phone',
    'email',
))


class BaseReserveRequestOld(namedtuple_with_defaults('BaseReserveRequestOld', (
    'arrival_point_code',
    'bedding',
    'coach_number',
    'coach_type',
    'departure_point_code',
    'electronic_registration',
    'gender',
    'lang',
    'lower_places_quantity',
    'max_place_number',
    'min_place_number',
    'passengers',
    'places_location',
    'places_option',
    'additional_place_requirements',
    'service_class',
    'storey',
    'train_number',
    'upper_places_quantity',
    'when',
    'arrangement',
))):
    def __new__(cls, **kwargs):
        kwargs.setdefault('passengers', [])
        return super(BaseReserveRequestOld, cls).__new__(cls, **kwargs)

    def add_passenger(self, **kwargs):
        self.passengers.append(ReserveRequestPassenger(**kwargs))

    def send(self):
        raise NotImplementedError


ReserveResponseTicket = namedtuple_with_defaults('ReserveResponseTicket', (
    'index',
    'customer_id',
    'amount',
    'service_price',
    'blank_id',
    'carrier_inn',
    'commission_fee_vat',
    'passenger_birth_date',
    'passenger_citizenship_country',
    'passenger_document_number',
    'passenger_document_type',
    'passenger_first_name',
    'passenger_gender',
    'passenger_last_name',
    'passenger_patronymic',
    'places',
    'places_type',
    'service_vat',
    'tariff_info',
    'raw_tariff_title',
    'tariff_vat',
))


class ReserveResponse(namedtuple_with_defaults('ReserveResponse', (
    'amount',
    'arrival_station_title',
    'coach_owner',
    'coach_number',
    'compartment_gender',
    'departure_station_title',
    'im_order_id',
    'operation_id',
    'reserved_to',
    'special_notice',
    'tickets',
    'time_notice',
    'is_three_hours_reservation_available',
    'is_suburban',
    'is_only_full_return_possible',
))):
    def __new__(cls, **kwargs):
        kwargs.setdefault('tickets', [])
        return super(ReserveResponse, cls).__new__(cls, **kwargs)

    def add_ticket(self, **kwargs):
        self.tickets.append(ReserveResponseTicket(**kwargs))


def get_notices(notice_parts):
    special_notice_parts = [part for part in notice_parts if not part.startswith(TIME_NOTICE_MARKER)]
    time_notice_parts = [part for part in notice_parts if part.startswith(TIME_NOTICE_MARKER)]

    return (
        '. '.join(special_notice_parts) or None,
        '. '.join(time_notice_parts) or None
    )
