# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import fields
from marshmallow.schema import Schema

from travel.rasp.train_api.serialization.schema_bases import PointsQuerySchema


class ScheduleQuerySchema(PointsQuerySchema):
    when = fields.DateTime(missing=None)
    time_from = fields.Integer(load_from='timeFrom', missing=0)
    time_to = fields.Integer(load_from='timeTo', missing=24)


class ScheduleSchema(Schema):
    start_sales_date_times = fields.List(fields.DateTime, dump_to='startSalesDateTimes')
