# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from enum import Enum


class BlankFormat(Enum):
    PDF = 'pdf'
    HTML = 'html'

    @property
    def mime_type(self):
        # XXX: может быть это возвращает GetTicketBlank в заголовках?
        if self == BlankFormat.PDF:
            return 'application/pdf'

        if self == BlankFormat.HTML:
            return 'text/html; charset=utf-8'

        raise TypeError('Do not know mime type of {}'.format(self))

    @classmethod
    def get_by_mime_type(cls, mime_type):
        if 'application/pdf' in mime_type:
            return cls.PDF

        elif 'text/html' in mime_type:
            return cls.HTML

        raise ValueError('Unknown mime type {}'.format(mime_type))


def download_ticket_blank(order, operation_id, blank_format=BlankFormat.PDF):
    from travel.rasp.train_api.train_partners import get_partner_api

    api = get_partner_api(order.partner)

    return api.download_ticket_blank(order, operation_id, blank_format)
