# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from collections import namedtuple
from django.conf import settings

from travel.rasp.train_api.train_purchase.core.models import ClientContracts

Facility = namedtuple('Facility', ['id', 'im_code', 'description'])

FACILITIES = [
    Facility(id='EAT', im_code='Meal', description='Питание'),
    Facility(id='PAP', im_code='Press', description='Пресса'),
    Facility(id='TV', im_code='Tv', description='Телевизор'),
    Facility(id='TRAN', im_code='Transfer', description='Трансфер'),
    Facility(id='COND', im_code='AirConditioning', description='Кондиционер'),
    Facility(id='BED', im_code='Bedclothes', description='Постельное белье'),
    Facility(id='SAN', im_code='HygienicKit', description='Санитарно-гигиенический набор'),
    Facility(id='WIFI', im_code='Wifi', description='WIFI'),
    Facility(id='WC', im_code='BioToilet', description='Биотуалет'),
    Facility(id='PLD', im_code='Plaid', description='Плед'),
    Facility(id='WSH', im_code='WashbasinInCompartment', description='Умывальник'),
    Facility(id='SWR', im_code='ShowerRoomInCompartment', description='Душевая'),
    Facility(id='HSWR', im_code='HygienicShower', description='Гигиенический душ'),
    Facility(id='S220', im_code='Socket220V', description='Розетка 220В'),
    Facility(id='SLPR', im_code='Slippers', description='Тапочки'),
    Facility(id='PETS', im_code='PetsCarriage', description='Провоз домашних животных'),
    Facility(id='BABY', im_code='PlacesForPassengerWithBaby', description='Места для пассажиров с детьми'),
]

FACILITIES_BY_IM = {f.im_code: f for f in FACILITIES}


class TrainDetailsQuery(object):
    def __init__(self, partner, station_from, station_to, when, number, include_price_fee=None,
                 price_exp_id=None, yandex_uid=None, provider=None, raw_query_data=None,
                 mock_im_path=None, mock_im_auto=False):
        self.partner = partner
        self.station_from = station_from
        self.station_to = station_to
        self.express_from = station_from.get_code('express')
        self.express_to = station_to.get_code('express')
        self.railway_dt = when
        self.number = number
        self.when = when
        self.contract = ClientContracts.get_active_contract(partner) if include_price_fee else None
        self.price_exp_id = price_exp_id
        self.yandex_uid = yandex_uid
        self.provider = provider
        self.raw_query_data = raw_query_data or {}
        self.mock_im_path = mock_im_path
        self.mock_im_auto = mock_im_auto

    @property
    def mock_im(self):
        return settings.ENABLE_MOCK_IM and (self.mock_im_path or self.mock_im_auto)
