# coding: utf-8

from __future__ import unicode_literals, absolute_import, division, print_function

from logging import getLogger

from common.utils.date import naive_to_timestamp, UTC_TZ
from travel.rasp.library.python.common23.date.environment import now_utc

bandit_train_details_log = getLogger('bandit_train_details_logger')
log = getLogger(__name__)


def log_details(train_details, query):
    for coach in train_details.coaches:
        try:
            sorted_by_price_places = sorted(coach.places, key=lambda place: place.adult_tariff.value)
            data = {
                'timestamp': naive_to_timestamp(now_utc()),
                'test_buckets': query.raw_query_data.get('test_buckets'),
                'req_id': query.raw_query_data.get('req_id'),
                'icookie': query.raw_query_data.get('icookie'),
                'yandex_uid': query.yandex_uid,
                'point_from': train_details.station_from.point_key,
                'point_to': train_details.station_to.point_key,
                'departure_dt': naive_to_timestamp(train_details.departure.astimezone(UTC_TZ).replace(tzinfo=None)),
                'arrival_dt': naive_to_timestamp(train_details.arrival.astimezone(UTC_TZ).replace(tzinfo=None)),
                'station_from_id': train_details.station_from.id,
                'station_to_id': train_details.station_to.id,
                'train_type': train_details.raw_train_name,
                'car_type': coach.type,
                'service_class': coach.service_class_code,
                'price': float(sorted_by_price_places[0].adult_tariff.value) if sorted_by_price_places else None,
                'fee': float(sorted_by_price_places[0].yandex_fee_percent) if sorted_by_price_places else None,
                'event_type': 'train-details',
            }
            bandit_train_details_log.info(msg=None, extra=data)
        except Exception:
            log.exception('Cannot log train details %s. Skipping.', train_details.start_number)
