# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.apps.train.models import TariffInfo


class ReservationVariant(object):
    def __init__(self, places_count, passengers, give_child_without_place=False,
                 original_amount=None, original_service_amount=None, original_non_refundable_amount=None):
        self.original_amount = original_amount
        self.original_non_refundable_amount = original_non_refundable_amount
        self.original_service_amount = original_service_amount
        self.amount = None
        self.non_refundable_amount = None
        self.places_count = places_count
        self.passengers = passengers
        self.give_child_without_place = give_child_without_place

    @staticmethod
    def generate_passengers_for_place_count(places_count, max_passengers=4):
        if places_count > max_passengers:
            places_count = max_passengers
        for adults in range(1, places_count + 1):
            childs = places_count - adults
            for babies in range(min(adults, max_passengers - places_count) + 1):
                yield {TariffInfo.FULL_CODE: adults, TariffInfo.CHILD_CODE: childs, TariffInfo.BABY_CODE: babies}

    def set_calculated_ticket_cost(self, ticket_cost):
        self.amount = ticket_cost.full_amount

    def set_non_refundable_amount(self, ticket_cost):
        self.non_refundable_amount = ticket_cost.full_amount

    def __str__(self):
        return "ReservationVariant(" + self.__dict__.__str__() + ")"
