# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api.train_partners.base.train_details.tariff_calculator.tariff_calculator import calc_tariff_by_coeff


def set_child_tariffs(coach):
    if coach.price_rules and not coach.price_rules[0].can_apply_for_child:
        _set_child_tariffs_by_base_tariff(coach)
    _set_child_tariffs_by_adult_tariffs(coach)


def _set_child_tariff(place, base_tariff, service_tariff, child_coeff):
    adult_tariff = base_tariff or place.original_adult_tariff
    child_tariff = _calc_child_tariff(child_coeff, adult_tariff, service_tariff)
    place.ensure_child_tariff(child_tariff)


def _set_child_tariffs_by_base_tariff(coach):
    for place in coach.iter_place_prices():
        _set_child_tariff(place, coach.base_tariff, coach.service_tariff, coach.child_coeff)


def _set_child_tariffs_by_adult_tariffs(coach):
    for place in coach.iter_place_prices():
        _set_child_tariff(place, None, coach.service_tariff, coach.child_coeff)


def _calc_child_tariff(child_coeff, adult_tariff, service_tariff):
    return calc_tariff_by_coeff(child_coeff, adult_tariff, service_tariff)
