# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from decimal import Decimal, ROUND_HALF_UP

from travel.rasp.train_api.train_partners.base.train_details.price_rules import is_base_rule
from travel.rasp.train_api.train_partners.base.train_details.utils import BRAND_SAPSAN, BRAND_LASTOCHKA


log = logging.getLogger(__name__)
CHILD_COEFF = Decimal('0.35')


def calc_tariff_by_coeff(coeff, tariff, service_tariff):
    """
    При вычислении тарифа со скидкой, скидка не распространяется на сервисные услуги.
    """
    return ((tariff - service_tariff) * coeff).quantize(Decimal('0.00'), rounding=ROUND_HALF_UP) + service_tariff


def get_bedding_tariff(coach_type, service_tariff):
    return service_tariff if coach_type == 'platzkarte' else Decimal(0)


def get_base_tariff(coach):
    """
    Вычисляет базовый (100%) тариф в вагоне по максимальному тарифу и первому правилу тарификации.
    """
    if not coach.price_rules:
        return None

    rule = coach.price_rules[0]
    if is_base_rule(rule):
        return coach.max_tariff

    coeff = Decimal(1 / (rule.price_percent / 100))
    return calc_tariff_by_coeff(coeff, coach.max_tariff, coach.service_tariff)


def get_pet_place_tariff(train_brand, when):
    """
    Возвращает стоимость провоза животных.
    :param train_brand: Бренд поезда: Сапсан, Ласточка.
    :param when: Дата отправления. Пока не используется. Ближе к Новому Году, скорее всего, будет использоваться.
    :return: Стоимость провоза животных в российских рублях.
    """
    if not train_brand:
        return 0

    train_brand = train_brand.upper()

    if train_brand == BRAND_SAPSAN:
        return 400

    if train_brand == BRAND_LASTOCHKA:
        return 150

    return 0
