# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from collections import namedtuple

from django.conf import settings
from rasp_vault.api import get_secret

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from travel.rasp.train_api.train_purchase.core.enums import TrainPartnerCredentialId


_env_im_url = os.getenv('RASP_TRAIN_API_IM_URL')

Credential = namedtuple('Credential', 'login, password, pos')

define_setting('TRAIN_PARTNERS_IM_URL', {
    Configuration.DEVELOPMENT: _env_im_url or 'https://testing.ipv4-proxy.internal.rasp.yandex.net/im-test/',
    Configuration.TESTING: _env_im_url or 'https://testing.ipv4-proxy.internal.rasp.yandex.net/im-test/',
    Configuration.PRODUCTION: _env_im_url or 'https://production.ipv4-proxy.internal.rasp.yandex.net/im/'
}, default=None)
TRAIN_PARTNERS_IM_URL = settings.TRAIN_PARTNERS_IM_URL

if settings.APPLIED_CONFIG == Configuration.PRODUCTION:
    _train_partners_im_login = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_LOGIN')
    _train_partners_im_password = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_PASSWORD')
    _train_partners_im_pos = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_POS')

    _train_partners_im_suburban_login = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_SUBURBAN_LOGIN')
    _train_partners_im_suburban_password = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_SUBURBAN_PASSWORD')
    _train_partners_im_suburban_pos = get_secret('rasp-train-api-production.TRAIN_PARTNERS_IM_SUBURBAN_POS')

else:
    _train_partners_im_login = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_LOGIN')
    _train_partners_im_password = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_PASSWORD')
    _train_partners_im_pos = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_POS')

    _train_partners_im_suburban_login = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_SUBURBAN_LOGIN')
    _train_partners_im_suburban_password = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_SUBURBAN_PASSWORD')
    _train_partners_im_suburban_pos = get_secret('rasp-train-api-testing.TRAIN_PARTNERS_IM_SUBURBAN_POS')

define_setting(
    'TRAIN_PARTNERS_IM_CREDENTIAL',
    default=Credential(_train_partners_im_login, _train_partners_im_password, _train_partners_im_pos)
)

define_setting(
    'TRAIN_PARTNERS_IM_SUBURBAN_CREDENTIAL',
    default=Credential(
        _train_partners_im_suburban_login, _train_partners_im_suburban_password, _train_partners_im_suburban_pos
    )
)

TRAIN_PARTNERS_CREDENTIALS = {
    TrainPartnerCredentialId.IM: settings.TRAIN_PARTNERS_IM_CREDENTIAL,
    TrainPartnerCredentialId.IM_SUBURBAN: settings.TRAIN_PARTNERS_IM_SUBURBAN_CREDENTIAL
}
