# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.train_api.train_partners.im.base import get_im_response, measurable
from travel.rasp.train_api.train_purchase.utils.electronic_registration import RegistrationStatus


log = logging.getLogger(__name__)


ELECTRONIC_REGISTRATION_ENDPOINT = 'Railway/V1/Reservation/ElectronicRegistration'


@measurable()
def change_electronic_registration(order, blank_ids, new_status):
    """
    :return: Status has updated
    """
    response = get_im_response(ELECTRONIC_REGISTRATION_ENDPOINT, {
        "OrderItemId": int(order.current_partner_data.operation_id),
        "OrderItemBlankIds": blank_ids,
        "Set": new_status == RegistrationStatus.ENABLED,
        "SendNotification": False
    }, credential_id=order.partner_credential_id)

    return bool(response['ExpirationElectronicRegistrationDateTime'])
