# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import factory

from travel.rasp.train_api.helpers.factory import fix_list_subfactory


class ImCreateReservationCustomerFactory(factory.DictFactory):
    Index = 1
    FirstName = 'Сидор'
    MiddleName = 'Сидорович'
    LastName = 'Сидоров'
    Sex = 'Male'  # SEX_VALUE_TO_GENDER.keys()
    BirthDate = '1990-01-01T00:00:00'
    DocumentNumber = '6504123456'
    DocumentType = 'RussianPassport'  # DOCUMENTTYPE_VALUE_TO_DOCUMENT_TYPE.keys()
    CitizenshipCode = 'RU'
    OrderCustomerId = 1


class ImCreateReservationBlankFactory(factory.DictFactory):
    AdditionalPrice = 755
    Amount = 1000
    ServicePrice = 100
    BaseFare = 868
    OrderItemBlankId = 1
    TariffInfo = {'TariffName': 'ПОЛНЫЙ', 'TariffType': 'Full'}
    TariffType = 'Full'
    VatRateValues = [
        {'Rate': 1.0, 'Value': 1.0},
        {'Rate': 2.0, 'Value': 2.0},
        {'Rate': 3.0, 'Value': 3.0},
    ]


class ImCreateReservationPassengerFactory(factory.DictFactory):
    Category = 'Adult'
    PlacesWithType = [{'Number': '38', 'Type': 'NotNearTable'}]
    Amount = 100
    OrderItemBlankId = 1
    OrderCustomerReferenceIndex = 1


class ImCreateReservationResultFactory(factory.DictFactory):
    OrderItemId = 1
    Amount = 100
    Blanks = factory.List([
        factory.SubFactory(ImCreateReservationBlankFactory)
    ])
    OriginStation = 'МОСКВА'
    DestinationStation = 'САНКТ-ПЕТЕРБУРГ'
    Carrier = 'ФПК'
    CarNumber = '2'
    TimeDescription = None
    ConfirmTill = '2000-01-01T12:00:00'
    Passengers = factory.List([
        factory.SubFactory(ImCreateReservationPassengerFactory)
    ])

    @classmethod
    def create(cls, **kwargs):
        fix_list_subfactory('Blanks', ImCreateReservationBlankFactory, kwargs)
        fix_list_subfactory('Passengers', ImCreateReservationPassengerFactory, kwargs)
        return super(ImCreateReservationResultFactory, cls).create(**kwargs)


class ImCreateReservationFactory(factory.DictFactory):
    # TODO связи между Customers, Blanks и Passengers
    OrderId = 1
    Customers = factory.List([
        factory.SubFactory(ImCreateReservationCustomerFactory)
    ])
    ReservationResults = factory.List([
        factory.SubFactory(ImCreateReservationResultFactory)
    ])

    @classmethod
    def create(cls, **kwargs):
        fix_list_subfactory('Customers', ImCreateReservationCustomerFactory, kwargs)
        fix_list_subfactory('ReservationResults', ImCreateReservationResultFactory, kwargs)
        return super(ImCreateReservationFactory, cls).create(**kwargs)
