# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json

from httpretty import Response

from travel.rasp.train_api.train_partners import config


IM_500_RESPONSE = Response(
    status=500,
    body="""{"Code":1, "Message":"Сервис временно недоступен", "MessageParams":[]}"""
)


def mock_im(httpretty, method, **kwargs):
    if 'json' in kwargs:
        kwargs['body'] = json.dumps(kwargs.pop('json'))
    httpretty.register_uri(
        httpretty.POST, '{config.TRAIN_PARTNERS_IM_URL}{method}'.format(config=config, method=method), **kwargs)


def mock_im_500(httpretty, method):
    return mock_im(httpretty, method, responses=[IM_500_RESPONSE])


def create_im_response(**kwargs):
    assert 'body' in kwargs or 'json' in kwargs
    if 'json' in kwargs:
        kwargs['body'] = json.dumps(kwargs.pop('json'))
    return Response(**kwargs)
