# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.encoding import force_text

from travel.rasp.train_api.train_partners.base.insurance.pricing import InsurancePricingResult, InsurancePricingException
from travel.rasp.train_api.train_partners.im.base import get_im_response, measurable


IM_INSURANCE_PRICING_METHOD = 'Insurance/V1/Travel/Pricing'


@measurable()
def pricing(order, timeout=None):
    if not order.current_partner_data or not order.current_partner_data.operation_id:
        raise InsurancePricingException('operation_id is not defined in order {}'.format(order.uid))

    params = {
        'Product': {
            '$type': 'ApiContracts.Insurance.V1.Messages.Travel.RailwayTravelPricingRequest, ApiContracts',
            'MainServiceReference': {
                '$type': 'ApiContracts.Insurance.V1.Messages.Travel.MainServiceReferenceInternal, ApiContracts',
                'OrderItemId': int(order.current_partner_data.operation_id),
            }
        }
    }

    return _pricing(params, credential_id=order.partner_credential_id, timeout=timeout)


def _pricing(params, credential_id, timeout=None):
    response = get_im_response(IM_INSURANCE_PRICING_METHOD, params, credential_id=credential_id, timeout=timeout)
    info_list = response['PricingResult']['ProductPricingInfoList']

    pricing_results = [InsurancePricingResult(
        customer_id=force_text(info['OrderCustomerId']),
        amount=info['Amount'],
        package=info['Package'],
        provider=info['Provider'],
        company=info['Company'],
        compensation=info['Compensation']
    ) for info in info_list]

    return pricing_results
