# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from decimal import Decimal

from django.utils.encoding import force_text

from travel.rasp.train_api.train_partners.base.insurance.refund import InsuranceRefundResult
from travel.rasp.train_api.train_partners.im.base import get_im_response


IM_INSURANCE_RETURN_METHOD = 'Insurance/V1/Travel/Return'


def insurance_refund(order, insurance_id, reference_id=None, timeout=None):
    params = {
        'OrderItemId': insurance_id,
        'AgentReferenceId': reference_id,
    }

    im_result = _return(params, credential_id=order.partner_credential_id, timeout=timeout)
    result = InsuranceRefundResult(
        amount=Decimal(im_result['Amount']),
        buy_operation_id=insurance_id,
        order_customer_id=force_text(im_result['OrderCustomerId']),
    )
    return result


def _return(params, credential_id, timeout=None):
    response = get_im_response(IM_INSURANCE_RETURN_METHOD, params, credential_id=credential_id, timeout=timeout)
    return response
