# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from decimal import Decimal

from travel.rasp.train_api.train_partners.im.base import get_im_response, measurable

IM_PARTNER_BALANCES_ENDPOINT = 'Partner/V1/Info/Balances'


@measurable()
def get_partner_balance():
    response = get_im_response(IM_PARTNER_BALANCES_ENDPOINT, {})
    total = Decimal(0)
    for account in response['AccountBalances']:
        total += Decimal(account['CurrentBalance'].replace('\xa0', '').replace(',', '.'))
    return total
